/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   PlayData.java

package ncsa.j3d.loaders.play;

import java.io.*;
import java.util.*;
import javax.media.j3d.*;
import ncsa.j3d.loaders.play.directives.Directive;

public class PlayData
{

    PlayData()
    {
        directives = new Vector();
        views = new Vector();
        initialViews = new Vector();
        groups = new Hashtable();
        index = 0;
        sensors = new Hashtable();
        reads = new Hashtable();
        root = new BranchGroup();
        root.setCapability(14);
        root.setCapability(13);
        root.setCapability(12);
        group = new BranchGroup();
        group.setCapability(14);
        group.setCapability(13);
        group.setCapability(12);
        group.setCapability(17);
        root.addChild(group);
    }

    public void addBranchGroup(BranchGroup branchgroup)
    {
        group.addChild(branchgroup);
    }

    void addDirective(Directive directive)
    {
        directives.addElement(directive);
    }

    public void addTransform(String s, TransformGroup transformgroup)
    {
        groups.put(s, transformgroup);
    }

    void addView(String s, TransformGroup transformgroup)
    {
        addTransform(s, transformgroup);
        views.addElement(s);
    }

    void decrementIndex()
    {
        index--;
    }

    int directivesSize()
    {
        return directives.size();
    }

    Directive getCurrentDirective()
    {
        return getDirective(index);
    }

    Directive getDirective(int i)
    {
        return (Directive)directives.elementAt(i);
    }

    Enumeration getDirectives()
    {
        return directives.elements();
    }

    BranchGroup getGroup()
    {
        return group;
    }

    int getIndex()
    {
        return index;
    }

    BranchGroup getRoot()
    {
        return root;
    }

    public Hashtable getSensorReadsHashtable()
    {
        return reads;
    }

    public Hashtable getSensorsHashtable()
    {
        return sensors;
    }

    public TransformGroup getTransform(String s)
    {
        return (TransformGroup)groups.get(s);
    }

    void incrementIndex()
    {
        index++;
    }

    void insertDirective(int i, Directive directive)
    {
        directives.add(i, directive);
    }

    Object removeDirective(int i)
    {
        return directives.remove(i);
    }

    void setIndex(int i)
    {
        index = i;
    }

    void setNextIndex()
    {
        incrementIndex();
    }

    public void write(OutputStream outputstream)
    {
        PrintWriter printwriter = new PrintWriter(outputstream, true);
        for(Enumeration enumeration = getDirectives(); enumeration.hasMoreElements(); ((Directive)enumeration.nextElement()).write(printwriter));
        printwriter.flush();
        printwriter.close();
    }

    public void write(String s)
    {
        try
        {
            write(((OutputStream) (new FileOutputStream(s))));
        }
        catch(IOException ioexception)
        {
            System.out.println("PlayData.write " + ioexception);
        }
    }

    Vector directives;
    Vector views;
    Vector initialViews;
    Hashtable groups;
    int index;
    BranchGroup group;
    BranchGroup root;
    Hashtable sensors;
    Hashtable reads;
}
