/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   PlayEditor.java

package ncsa.j3d.loaders.play;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.text.JTextComponent;
import ncsa.j3d.loaders.play.directives.Directive;
import ncsa.j3d.loaders.play.directives.Editor;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.play:
//            PlayData

public class PlayEditor
    implements ActionListener
{

    public PlayEditor(Editor editor1)
    {
        frame = null;
        list = new JList();
        edir = null;
        edir = editor1;
        frame = new Frame("Play Editor");
        frame.setLayout(new BorderLayout());
        WindowAdapter windowadapter = new WindowAdapter() {

            public void windowClosing(WindowEvent windowevent)
            {
                System.exit(0);
            }

        };
        frame.addWindowListener(windowadapter);
        frame.setMenuBar(createMenuBar());
        JScrollPane jscrollpane = new JScrollPane(list);
        frame.add(jscrollpane);
        frame.setSize(300, 300);
        frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionevent)
    {
        String s = actionevent.getActionCommand();
        if(s.equals("Edit"))
            edit(list.getSelectedIndex());
        if(s.equals("Remove"))
            data.removeDirective(list.getSelectedIndex());
        if(s.equals("Insert"))
            insert(list.getSelectedIndex());
        if(s.equals("Append"))
            insert(list.getSelectedIndex() + 1);
        if(s.equals("Save"))
        {
            JFileChooser jfilechooser = new JFileChooser();
            jfilechooser.showSaveDialog(frame);
            java.io.File file = jfilechooser.getSelectedFile();
            try
            {
                data.write(new FileOutputStream(file));
            }
            catch(IOException ioexception)
            {
                System.out.println(ioexception);
            }
        }
        refresh();
    }

    protected Directive composeDirective(String s)
    {
        try
        {
            StringReader stringreader = new StringReader(s);
            ReaderTokenizer readertokenizer = new ReaderTokenizer(stringreader);
            readertokenizer.wordChars(47, 47);
            int i = readertokenizer.nextToken();
            Directive directive = (Directive)Class.forName(readertokenizer.sval).newInstance();
            directive.setReader(edir.getReader());
            directive.initialize(readertokenizer);
            return directive;
        }
        catch(Exception exception)
        {
            System.out.println("PlayEditor.composeDirective");
            System.out.println(exception);
            return null;
        }
    }

    protected MenuBar createMenuBar()
    {
        Menu menu = new Menu("Command");
        menu.add(register(new MenuItem("Edit")));
        menu.add(register(new MenuItem("Insert")));
        menu.add(register(new MenuItem("Append")));
        menu.add(register(new MenuItem("Remove")));
        Menu menu1 = new Menu("File");
        menu1.add(register(new MenuItem("Save")));
        MenuBar menubar = new MenuBar();
        menubar.add(menu1);
        menubar.add(menu);
        return menubar;
    }

    protected void edit(int i)
    {
        if(i == -1)
        {
            return;
        } else
        {
            Directive directive = data.getDirective(i);
            String s = writeDirective(directive);
            s = editor(s);
            directive = composeDirective(s);
            data.removeDirective(i);
            data.insertDirective(i, directive);
            return;
        }
    }

    protected String editor(String s)
    {
        JDialog jdialog = new JDialog(frame, "Command Editor", true);
        JTextArea jtextarea = new JTextArea(s);
        jtextarea.setSize(jtextarea.getPreferredSize());
        jdialog.getContentPane().add(jtextarea);
        jdialog.show();
        return jtextarea.getText();
    }

    protected void insert(int i)
    {
        if(i == -1)
        {
            return;
        } else
        {
            Directive directive = composeDirective(editor(null));
            data.insertDirective(i, directive);
            return;
        }
    }

    public static void main(String args[])
    {
        Editor editor1 = new Editor();
        PlayEditor playeditor = new PlayEditor(editor1);
        playeditor.setData(new PlayData());
    }

    public void refresh()
    {
        list.setListData(data.directives);
    }

    protected MenuItem register(MenuItem menuitem)
    {
        menuitem.addActionListener(this);
        return menuitem;
    }

    public void setData(PlayData playdata)
    {
        data = playdata;
        refresh();
    }

    protected String writeDirective(Directive directive)
    {
        try
        {
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            PrintWriter printwriter = new PrintWriter(bytearrayoutputstream);
            directive.write(printwriter);
            printwriter.flush();
            bytearrayoutputstream.flush();
            return bytearrayoutputstream.toString();
        }
        catch(Exception exception)
        {
            System.out.println("PlayEditor.writeDirective");
            System.out.println(exception);
            return null;
        }
    }

    Frame frame;
    PlayData data;
    JList list;
    Editor edir;
}
