/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   PlayReader.java

package ncsa.j3d.loaders.play;

import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Enumeration;
import javax.media.j3d.*;
import javax.vecmath.Point3d;
import ncsa.j3d.loaders.play.directives.Directive;
import ncsa.j3d.ui.record.NeedsCanvasForRecord;
import ncsa.j3d.ui.record.RendezvousInterface;

// Referenced classes of package ncsa.j3d.loaders.play:
//            DirectiveInterface, PlayConfiguration, PlayData, PlayParser, 
//            TimeBase

public class PlayReader extends Behavior
    implements DirectiveInterface, Runnable, NeedsCanvasForRecord
{

    public PlayReader(Reader reader)
    {
        this(reader, new PlayData());
    }

    public PlayReader(Reader reader, PlayData playdata)
    {
        state = new PlayConfiguration();
        thread = null;
        time = null;
        data = playdata;
        setSchedulingBounds(new BoundingSphere(new Point3d(), 100000D));
        if(reader != null)
        {
            PlayParser playparser = new PlayParser(reader);
            playparser.setInterface(this);
            playparser.process();
        }
    }

    public PlayReader(PlayData playdata)
    {
        this(null, playdata);
    }

    public Scene consume()
    {
        SceneBase scenebase = new SceneBase();
        scenebase.setSceneGroup(data.getRoot());
        scenebase.addDescription("PLAY File");
        scenebase.addBehaviorNode(this);
        return scenebase;
    }

    public PlayData getData()
    {
        return data;
    }

    public PlayConfiguration getState()
    {
        return state;
    }

    public void initialize()
    {
        time = new TimeBase(state);
        wakeupOn(new WakeupOnActivation());
    }

    public void initializeDirective(Directive directive)
    {
        directive.setReader(this);
    }

    protected void process(Directive directive)
    {
        time.startNewEvent();
        try
        {
            for(; directive.getTime() > time.elapsed() && directive.intermediate(time.elapsed()); time.increment())
            {
                state.rendezvous();
                Thread.yield();
            }

        }
        catch(Exception exception)
        {
            System.out.println("PlayReader.process - intermediate");
            System.out.println(directive.toString());
            System.out.println(exception);
        }
        if(state.getStall())
            time.stall(directive.getTime());
        state.rendezvous();
        directive.execute();
        time.increment();
        data.setNextIndex();
    }

    public void processDirective(Directive directive)
    {
        getData().addDirective(directive);
    }

    public void processStimulus(Enumeration enumeration)
    {
        thread = new Thread(this);
        thread.start();
    }

    public void rendezvous()
    {
        state.rendezvous();
    }

    protected void reset()
    {
        for(Enumeration enumeration = getData().getDirectives(); enumeration.hasMoreElements(); ((Directive)enumeration.nextElement()).reset());
    }

    public void run()
    {
        while(state.getLoop()) 
        {
            data.setIndex(0);
            for(; data.getIndex() < data.directivesSize(); process(data.getCurrentDirective()));
            if(state.getLoop())
            {
                time.startNewEvent();
                reset();
                time.stall(state.getLagTime());
            }
        }
        System.out.println("PLAY done");
    }

    public void setRendezvous(RendezvousInterface rendezvousinterface)
    {
        state.setRendezvous(rendezvousinterface);
    }

    PlayConfiguration state;
    PlayData data;
    Thread thread;
    TimeBase time;
}
