/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   PlayWriter.java

package ncsa.j3d.loaders.play;

import java.io.*;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import ncsa.j3d.PickableTransformGroup;
import ncsa.j3d.loaders.play.directives.Directive;
import ncsa.j3d.loaders.play.directives.LoadFile;
import ncsa.j3d.loaders.play.directives.Transform;
import ncsa.j3d.ui.record.RecordableTransform;

public class PlayWriter
{

    public PlayWriter()
    {
    }

    public static void close()
    {
        if(filename == null)
            return;
        out.flush();
        out.close();
        out = null;
        if(debug)
            System.out.println("Closing record file");
    }

    protected static long generateTimeStamp()
    {
        long l = System.currentTimeMillis();
        long l1 = last != 0L ? l - last : last;
        last = l;
        return l1;
    }

    public static void loadFile(String s)
    {
        filename = s;
    }

    public static void nameFile(PickableTransformGroup pickabletransformgroup)
    {
        writeFile(filename, pickabletransformgroup.getName());
    }

    public static void nameFile(RecordableTransform recordabletransform)
    {
        writeFile(filename, recordabletransform.getDescription());
    }

    public static void open(String s)
    {
        if(out != null)
            return;
        try
        {
            out = new PrintWriter(new FileOutputStream(s + ".play"), true);
            startTime = System.currentTimeMillis();
            if(debug)
                System.out.println("Opened " + s + ".play");
        }
        catch(IOException ioexception)
        {
            System.out.println("Recorder " + ioexception);
        }
    }

    public static void write(String s, double d)
    {
        System.out.println("should not be writing  DOUBLE " + s + " " + d);
    }

    public static void write(String s, int i)
    {
        System.out.println("should not be writing  INTEGER " + s + " " + i);
    }

    public static void write(String s, TransformGroup transformgroup)
    {
        if(out == null)
            return;
        Transform transform = new Transform();
        double ad[] = new double[16];
        Transform3D transform3d = new Transform3D();
        transformgroup.getTransform(transform3d);
        transform3d.get(ad);
        String s1 = generateTimeStamp() + " " + s + " " + ad[0] + " " + ad[1] + " " + ad[2] + " " + ad[3] + " " + ad[4] + " " + ad[5] + " " + ad[6] + " " + ad[7] + " " + ad[8] + " " + ad[9] + " " + ad[10] + " " + ad[11] + " " + ad[12] + " " + ad[13] + " " + ad[14] + " " + ad[15];
        transform.initialize(s1);
        write(((Directive) (transform)));
        if(debug)
            System.out.println("wrote " + s);
    }

    public static void write(String s, boolean flag)
    {
        System.out.println("should not be writing BOOLEAN " + s + " " + flag);
    }

    public static void write(String s, double ad[])
    {
        System.out.println("Should not be writing double[]  " + s);
    }

    public static void write(PickableTransformGroup pickabletransformgroup)
    {
        write(pickabletransformgroup.getName(), ((TransformGroup) (pickabletransformgroup)));
    }

    public static void write(Directive directive)
    {
        if(out == null)
        {
            return;
        } else
        {
            directive.setTime(generateTimeStamp());
            out.println(directive.toString());
            out.flush();
            return;
        }
    }

    public static void write(RecordableTransform recordabletransform)
    {
        if(out == null)
        {
            return;
        } else
        {
            write(recordabletransform.getDescription(), ((TransformGroup) (recordabletransform)));
            return;
        }
    }

    public static void writeFile(String s, String s1)
    {
        if(out == null)
        {
            return;
        } else
        {
            LoadFile loadfile = new LoadFile();
            loadfile.initialize(s + " " + s1);
            write(loadfile);
            return;
        }
    }

    protected static PrintWriter out = null;
    protected static long startTime = 0L;
    protected static String filename;
    public static boolean debug = false;
    protected static long last = 0L;

}
