/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SensorDevice.java

package ncsa.devices.wand;

import javax.media.j3d.*;
import javax.vecmath.Vector3d;

public class SensorDevice
    implements InputDevice
{

    public SensorDevice(String s, int i)
    {
        transform = new Transform3D();
        vector = new Vector3d();
        processingMode = 5;
        name = s;
        buttons = new int[i];
        sensorRead = new SensorRead(i);
        sensor = new Sensor(this, 30, i);
    }

    public void close()
    {
    }

    public int getProcessingMode()
    {
        return processingMode;
    }

    public Sensor getSensor(int i)
    {
        return i != 0 ? null : sensor;
    }

    public int getSensorCount()
    {
        return 1;
    }

    public boolean initialize()
    {
        return true;
    }

    public void pollAndProcessInput()
    {
        sensorRead.setTime(System.currentTimeMillis());
        sensorRead.setButtons(buttons);
        transform.setTranslation(vector);
        sensorRead.set(transform);
        sensor.setNextSensorRead(sensorRead);
    }

    public void processStreamInput()
    {
    }

    public void set(Transform3D transform3d)
    {
        transform.set(transform3d);
    }

    public void set(int ai[])
    {
        if(buttons == null)
            return;
        for(int i = 0; i < ai.length && i < buttons.length; i++)
            buttons[i] = ai[i];

    }

    public void setNominalPositionAndOrientation()
    {
    }

    public void setProcessingMode(int i)
    {
    }

    protected Transform3D transform;
    protected Vector3d vector;
    protected Sensor sensor;
    protected SensorRead sensorRead;
    protected int buttons[];
    private int processingMode;
    protected String name;
}
