/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   LoadFile.java

package ncsa.j3d.loaders.play.directives;

import com.sun.j3d.loaders.Scene;
import java.io.PrintStream;
import javax.media.j3d.*;
import ncsa.j3d.PickableTransformGroup;
import ncsa.j3d.loaders.ModelLoader;
import ncsa.j3d.loaders.play.*;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.play.directives:
//            Directive

public class LoadFile extends Directive
{

    public LoadFile()
    {
        fileName = null;
        groupName = null;
    }

    public void execute()
    {
        if(!bg.isLive())
            super.reader.getData().addBranchGroup(bg);
    }

    public void initialize(ReaderTokenizer readertokenizer)
    {
        int i = readertokenizer.nextToken();
        fileName = readertokenizer.sval;
        i = readertokenizer.nextToken();
        groupName = readertokenizer.sval;
        if(super.reader != null)
            setup();
    }

    public void reset()
    {
        TransformGroup transformgroup = super.reader.getData().getTransform(groupName);
        if(transformgroup != null)
            transformgroup.setTransform(new Transform3D());
        if(super.reader.getState().getObliteration())
            undo();
    }

    protected void setup()
    {
        try
        {
            PickableTransformGroup pickabletransformgroup = new PickableTransformGroup();
            ModelLoader modelloader = new ModelLoader();
            Scene scene = modelloader.load(fileName);
            pickabletransformgroup.addChild(scene.getSceneGroup());
            bg = new BranchGroup();
            bg.setCapability(17);
            super.reader.getData().addTransform(groupName, pickabletransformgroup);
            bg.addChild(pickabletransformgroup);
        }
        catch(Exception exception)
        {
            System.out.println(toString());
            System.out.println(exception);
        }
    }

    public String toString()
    {
        return "ncsa.j3d.loaders.play.directives.LoadFile " + fileName + " " + groupName;
    }

    public void undo()
    {
        try
        {
            bg.detach();
        }
        catch(Exception exception)
        {
            System.out.println(toString());
            System.out.println(exception);
        }
    }

    String fileName;
    String groupName;
    BranchGroup bg;
}
