/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   Rotate.java

package ncsa.j3d.loaders.play.directives;

import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import ncsa.j3d.loaders.play.PlayData;
import ncsa.j3d.loaders.play.PlayReader;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.play.directives:
//            Directive

public class Rotate extends Directive
{

    public Rotate()
    {
        _t = new Transform3D();
        _r = new Transform3D();
    }

    public void execute()
    {
        rotate(angle - intermediate);
        intermediate = 0.0D;
    }

    public void initialize(ReaderTokenizer readertokenizer)
    {
        int i = readertokenizer.nextToken();
        super.time = (long)readertokenizer.nval;
        i = readertokenizer.nextToken();
        name = readertokenizer.sval;
        i = readertokenizer.nextToken();
        axis = readertokenizer.sval;
        i = readertokenizer.nextToken();
        angle = readertokenizer.nval;
        intermediate = 0.0D;
    }

    public boolean intermediate(long l)
    {
        if(super.time == 0L)
        {
            return false;
        } else
        {
            double d = ((double)l / (double)super.time) * angle;
            rotate(d - intermediate);
            intermediate = d;
            return true;
        }
    }

    protected void rotate(double d)
    {
        double d1 = d * 0.017453292519943295D;
        TransformGroup transformgroup = super.reader.getData().getTransform(name);
        if(transformgroup != null)
        {
            transformgroup.getTransform(_t);
            _r.setIdentity();
            if(axis.equalsIgnoreCase("x"))
                _r.rotX(d1);
            else
            if(axis.equalsIgnoreCase("y"))
                _r.rotY(d1);
            else
            if(axis.equalsIgnoreCase("z"))
                _r.rotZ(d1);
            _t.mul(_r);
            transformgroup.setTransform(_t);
        }
    }

    public String toString()
    {
        return "ncsa.j3d.loaders.play.directives.Rotate " + super.time + " " + name + " " + axis + " " + angle;
    }

    double angle;
    String axis;
    String name;
    double intermediate;
    Transform3D _t;
    Transform3D _r;
}
