/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SensorDirective.java

package ncsa.j3d.loaders.play.directives;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.media.j3d.*;
import ncsa.devices.NCSAInputDevice;
import ncsa.j3d.loaders.play.PlayData;
import ncsa.j3d.loaders.play.PlayReader;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.tools.ToolManager;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.play.directives:
//            Directive

public class SensorDirective extends Directive
    implements InputDevice
{

    public SensorDirective()
    {
        matrix = new double[16];
    }

    public SensorDirective(Sensor sensor)
    {
        matrix = new double[16];
        buttons = new int[sensor.getSensorButtonCount()];
        InputDevice inputdevice = sensor.getDevice();
        if(inputdevice instanceof NCSAInputDevice)
            name = ((NCSAInputDevice)inputdevice).getName();
        else
            name = sensor.toString();
        Transform3D transform3d = new Transform3D();
        sensor.getRead(transform3d);
        transform3d.get(matrix);
        sensor.lastButtons(buttons);
    }

    public void close()
    {
    }

    public boolean equals(Object obj)
    {
        if(obj == null || !(obj instanceof SensorDirective))
            return super.equals(obj);
        SensorDirective sensordirective = (SensorDirective)obj;
        for(int i = 0; i < matrix.length; i++)
            if(matrix[i] != sensordirective.matrix[i])
                return false;

        if(buttons.length != sensordirective.buttons.length)
            return false;
        for(int j = 0; j < buttons.length; j++)
            if(buttons[j] != sensordirective.buttons[j])
                return false;

        return true;
    }

    public void execute()
    {
        Transform3D transform3d = new Transform3D(matrix);
        SensorRead sensorread = getSensorRead();
        sensorread.setTime(System.currentTimeMillis());
        if(buttons.length > 0)
            sensorread.setButtons(buttons);
        sensorread.set(transform3d);
        getSensor().setNextSensorRead(sensorread);
    }

    public String getName()
    {
        return name;
    }

    public int getProcessingMode()
    {
        return 4;
    }

    public Sensor getSensor()
    {
        return getSensor(0);
    }

    public Sensor getSensor(int i)
    {
        Hashtable hashtable = super.reader.getData().getSensorsHashtable();
        if(hashtable.containsKey(name))
            return (Sensor)hashtable.get(name);
        Sensor sensor = null;
        Canvas3D canvas3d = ToolManager.instance().getCanvas();
        PhysicalEnvironment physicalenvironment = canvas3d.getView().getPhysicalEnvironment();
        PortfolioProperties portfolioproperties = PortfolioProperties.instance();
        String s = portfolioproperties.getProperty(name + ".Channel");
        if(s != null)
            sensor = physicalenvironment.getSensor(Integer.parseInt(s));
        else
            System.out.println("ERROR: " + name + ".Channel not defined in portfolio.properties. The sensor cannot appear to the application.");
        hashtable.put(name, sensor);
        return sensor;
    }

    public int getSensorCount()
    {
        return 1;
    }

    protected SensorRead getSensorRead()
    {
        Hashtable hashtable = super.reader.getData().getSensorReadsHashtable();
        if(hashtable.containsKey(name))
        {
            return (SensorRead)hashtable.get(name);
        } else
        {
            SensorRead sensorread = new SensorRead(buttons.length);
            hashtable.put(name, sensorread);
            return sensorread;
        }
    }

    public boolean initialize()
    {
        return true;
    }

    public void initialize(ReaderTokenizer readertokenizer)
    {
        int i = readertokenizer.nextToken();
        super.time = (long)readertokenizer.nval;
        i = readertokenizer.nextToken();
        name = readertokenizer.sval;
        for(int k = 0; k < matrix.length; k++)
        {
            i = readertokenizer.nextToken();
            matrix[k] = readertokenizer.nval;
        }

        i = readertokenizer.nextToken();
        buttons = new int[(int)readertokenizer.nval];
        for(int l = 0; l < buttons.length; l++)
        {
            int j = readertokenizer.nextToken();
            buttons[l] = (int)readertokenizer.nval;
        }

    }

    public boolean intermediate(long l)
    {
        return false;
    }

    public void pollAndProcessInput()
    {
    }

    public void processStreamInput()
    {
    }

    void set(Transform3D transform3d)
    {
    }

    public void setNominalPositionAndOrientation()
    {
    }

    public void setProcessingMode(int i)
    {
    }

    public String toString()
    {
        String s = "ncsa.j3d.loaders.play.directives.SensorDirective " + super.time + " " + name + " " + matrix[0] + " " + matrix[1] + " " + matrix[2] + " " + matrix[3] + " " + matrix[4] + " " + matrix[5] + " " + matrix[6] + " " + matrix[7] + " " + matrix[8] + " " + matrix[9] + " " + matrix[10] + " " + matrix[11] + " " + matrix[12] + " " + matrix[13] + " " + matrix[14] + " " + matrix[15] + " " + buttons.length;
        for(int i = 0; i < buttons.length; i++)
            s = s + " " + buttons[i];

        return s;
    }

    String name;
    double matrix[];
    int buttons[];
}
