/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   MFString.java

package ncsa.j3d.loaders.vrml97;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.vrml97:
//            VRMLType

public class MFString extends VRMLType
{

    public MFString()
    {
    }

    public MFString(String s)
    {
        value = new Vector();
        value.addElement(s);
    }

    public MFString(String s, String s1)
    {
        value = new Vector();
        value.addElement(s);
        value.addElement(s1);
    }

    public void dump(PrintWriter printwriter, String s)
    {
        if(value == null)
        {
            printwriter.println(" []");
            return;
        }
        int i = value.size();
        if(i == 0)
        {
            printwriter.println(" []");
            return;
        }
        if(i == 1)
        {
            String s1 = (String)value.elementAt(0);
            String s2 = escapeQuotes(s1);
            printwriter.println("\"" + s2 + "\"");
            return;
        }
        printwriter.println(" [");
        for(int j = 0; j < i; j++)
        {
            String s3 = (String)value.elementAt(j);
            String s4 = escapeQuotes(s3);
            printwriter.println(s + s + "\"" + s4 + "\"");
        }

        printwriter.println(s + "]");
    }

    public String escapeQuotes(String s)
    {
        StringBuffer stringbuffer = new StringBuffer(s);
        for(int i = 0; i < stringbuffer.length(); i++)
            if(stringbuffer.charAt(i) == '"')
            {
                stringbuffer.insert(i, '\\');
                i++;
            }

        return new String(stringbuffer);
    }

    public String getElement(int i)
    {
        return (String)value.elementAt(i);
    }

    public String[] getString()
    {
        int i = value.size();
        if(i == 0)
            return null;
        String as[] = new String[i];
        for(int j = 0; j < i; j++)
            as[j] = getElement(j);

        return as;
    }

    public boolean populate(ReaderTokenizer readertokenizer)
    {
        try
        {
            readertokenizer.nextToken();
        }
        catch(Exception _ex)
        {
            System.out.println("error on line " + readertokenizer.lineno());
            return false;
        }
        if(readertokenizer.ttype == 34)
        {
            value = new Vector();
            value.addElement(readertokenizer.sval);
            return true;
        }
        if(readertokenizer.ttype != 91)
        {
            System.out.print("MFS 1: error on line " + readertokenizer.lineno());
            System.out.println(" " + readertokenizer.ttype);
            return false;
        }
        try
        {
            readertokenizer.nextToken();
        }
        catch(Exception _ex)
        {
            System.out.println("MFS 2: error on line " + readertokenizer.lineno() + " " + readertokenizer.ttype);
            return false;
        }
        while(readertokenizer.ttype != 93) 
        {
            if(readertokenizer.ttype != 34)
            {
                System.out.println("MFS 3: error on line " + readertokenizer.lineno() + " " + readertokenizer.ttype);
                return false;
            }
            if(value == null)
                value = new Vector();
            value.addElement(readertokenizer.sval);
            try
            {
                readertokenizer.nextToken();
            }
            catch(Exception _ex)
            {
                System.out.println("MFS 4: error on line " + readertokenizer.lineno() + " " + readertokenizer.ttype);
                return false;
            }
        }
        return true;
    }

    Vector value;
}
