/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SFInt32.java

package ncsa.j3d.loaders.vrml97;

import java.io.PrintStream;
import java.io.PrintWriter;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.vrml97:
//            VRMLType

public class SFInt32 extends VRMLType
{

    public SFInt32()
    {
    }

    public SFInt32(int i)
    {
        value = i;
    }

    public void dump(PrintWriter printwriter, String s)
    {
        printwriter.println(s + value);
    }

    public boolean equals(Object obj)
    {
        SFInt32 sfint32 = (SFInt32)obj;
        return sfint32.getValue() == value;
    }

    public int getValue()
    {
        return value;
    }

    public boolean populate(ReaderTokenizer readertokenizer)
    {
        try
        {
            readertokenizer.nextToken();
        }
        catch(Exception _ex)
        {
            System.out.println("error at " + readertokenizer.lineno());
            return false;
        }
        if(readertokenizer.ttype == -102)
        {
            value = (new Float(readertokenizer.nval)).intValue();
            return true;
        }
        if(readertokenizer.ttype == -101)
        {
            if(!readertokenizer.sval.startsWith("0x"))
            {
                System.out.println("Error at " + readertokenizer.lineno() + " " + readertokenizer.sval);
                return false;
            }
            try
            {
                value = Integer.decode(readertokenizer.sval).intValue();
            }
            catch(NumberFormatException _ex)
            {
                System.out.print("Value " + readertokenizer.sval + " on line ");
                System.out.println(readertokenizer.lineno() + " is invalid");
                return false;
            }
            return true;
        } else
        {
            System.out.println("Error at " + readertokenizer.lineno() + " " + readertokenizer.sval);
            return false;
        }
    }

    int value;
}
