/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SFRotation.java

package ncsa.j3d.loaders.vrml97;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.vrml97:
//            VRMLType

public class SFRotation extends VRMLType
{

    public SFRotation()
    {
    }

    public SFRotation(int i, int j, int k, int l)
    {
        x = i;
        y = j;
        z = k;
        radians = l;
    }

    public void dump(PrintWriter printwriter, String s)
    {
        printwriter.println(s + x + " " + y + " " + z + " " + radians);
    }

    public boolean equals(Object obj)
    {
        SFRotation sfrotation = (SFRotation)obj;
        float af[] = new float[4];
        sfrotation.getValue(af);
        return af[0] == x && af[1] == y && af[2] == z && af[3] == radians;
    }

    public AxisAngle4f getAxisAngle4f()
    {
        return new AxisAngle4f(x, y, z, radians);
    }

    public void getValue(float af[])
    {
        af[0] = x;
        af[1] = y;
        af[2] = z;
        af[3] = radians;
    }

    public boolean populate(ReaderTokenizer readertokenizer)
    {
        Vector vector = new Vector(4);
        for(int i = 0; i < 4; i++)
        {
            try
            {
                readertokenizer.nextToken();
            }
            catch(Exception _ex)
            {
                System.out.println("error at " + readertokenizer.lineno());
                return false;
            }
            if(readertokenizer.ttype != -102)
            {
                System.out.print("Error at " + readertokenizer.lineno() + " st.sval=" + readertokenizer.sval + ", st.ttype = " + readertokenizer.ttype + ": ");
                System.out.println(" expected floating point number");
                return false;
            }
            vector.addElement(new Float(readertokenizer.nval));
        }

        x = ((Float)vector.elementAt(0)).floatValue();
        y = ((Float)vector.elementAt(1)).floatValue();
        z = ((Float)vector.elementAt(2)).floatValue();
        radians = ((Float)vector.elementAt(3)).floatValue();
        return true;
    }

    float x;
    float y;
    float z;
    float radians;
}
