/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SFVec3f.java

package ncsa.j3d.loaders.vrml97;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.vecmath.Vector3f;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.vrml97:
//            VRMLType

public class SFVec3f extends VRMLType
{

    public SFVec3f()
    {
    }

    public SFVec3f(float f, float f1, float f2)
    {
        x = f;
        y = f1;
        z = f2;
    }

    public void dump(PrintWriter printwriter, String s)
    {
        printwriter.println(s + x + " " + y + " " + z);
    }

    public boolean equals(Object obj)
    {
        SFVec3f sfvec3f = (SFVec3f)obj;
        return sfvec3f.getX() == x && sfvec3f.getY() == y && sfvec3f.getZ() == z;
    }

    public Vector3f getVector3f()
    {
        return new Vector3f(x, y, z);
    }

    public float getX()
    {
        return x;
    }

    public float getY()
    {
        return y;
    }

    public float getZ()
    {
        return z;
    }

    public boolean populate(ReaderTokenizer readertokenizer)
    {
        Vector vector = new Vector(3);
        for(int i = 0; i < 3; i++)
        {
            try
            {
                readertokenizer.nextToken();
            }
            catch(Exception _ex)
            {
                System.out.println("0 error at " + readertokenizer.lineno());
                return false;
            }
            if(readertokenizer.ttype != -102)
            {
                System.out.println("1 Error at " + readertokenizer.lineno() + "<" + readertokenizer.sval + ">" + readertokenizer.ttype);
                return false;
            }
            vector.addElement(new Float(readertokenizer.nval));
        }

        x = ((Float)vector.elementAt(0)).floatValue();
        y = ((Float)vector.elementAt(1)).floatValue();
        z = ((Float)vector.elementAt(2)).floatValue();
        return true;
    }

    public float x;
    public float y;
    public float z;
}
