/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   VRMLNode.java

package ncsa.j3d.loaders.vrml97;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import ncsa.j3d.loaders.vrml97.util.ToolkitImpl;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.vrml97:
//            MFNode, VRMLNodeManager, VRMLType

public class VRMLNode
    implements Cloneable
{

    public VRMLNode()
    {
        me = null;
        myname = null;
        nodeManager = null;
        defName = null;
        useName = null;
        impl = null;
        me = getClass();
        myname = me.getName();
    }

    public void Debug(String s)
    {
        if(nodeManager.isDebug())
            System.out.println(s);
    }

    public boolean advance(ReaderTokenizer readertokenizer)
    {
        try
        {
            readertokenizer.nextToken();
        }
        catch(Exception exception)
        {
            System.out.println(exception);
            return false;
        }
        return true;
    }

    public Object clone()
    {
        try
        {
            return super.clone();
        }
        catch(Exception exception)
        {
            System.out.println(myname + ": " + exception);
        }
        return null;
    }

    public VRMLNode consume(ReaderTokenizer readertokenizer)
    {
        if(readertokenizer.ttype == -101)
            if(readertokenizer.sval.equals("DEF"))
            {
                defName = getWord(readertokenizer);
                if(defName == null)
                    return null;
                String s = getWord(readertokenizer);
                if(s == null)
                    return null;
                if(!myname.equals(nodeManager.getPackageName() + "VRML" + s))
                {
                    System.out.print("Error on line " + readertokenizer.lineno());
                    System.out.println(": invalid name specified: " + s);
                    System.out.println("myname = " + myname);
                    System.out.println("other is = " + nodeManager.getPackageName() + s);
                }
            } else
            {
                if(readertokenizer.sval.equals("USE"))
                {
                    String s1 = getWord(readertokenizer);
                    if(s1 == null)
                        return null;
                    VRMLNode vrmlnode = nodeManager.getDEF(s1);
                    if(vrmlnode == null)
                    {
                        return null;
                    } else
                    {
                        VRMLNode vrmlnode1 = (VRMLNode)vrmlnode.clone();
                        vrmlnode1.setUSE(s1);
                        return vrmlnode1;
                    }
                }
                if(readertokenizer.sval.equals("NULL"))
                    return null;
            }
        try
        {
            readertokenizer.nextToken();
        }
        catch(Exception _ex)
        {
            return null;
        }
        if(readertokenizer.ttype != 123)
        {
            System.out.println("1a error at " + readertokenizer.lineno());
            return null;
        }
        do
        {
            try
            {
                readertokenizer.nextToken();
            }
            catch(Exception _ex)
            {
                return null;
            }
            if(readertokenizer.ttype == 125)
                return this;
            if(readertokenizer.ttype != -101)
                return null;
            Field field = nodeManager.getField(this, readertokenizer.sval);
            if(field == null)
            {
                System.out.println("1b error at " + readertokenizer.lineno());
                return null;
            }
            Object obj = null;
            try
            {
                VRMLType vrmltype = (VRMLType)field.getType().newInstance();
                vrmltype.setVRMLNodeManager(nodeManager);
                if(!advance(readertokenizer))
                    return null;
                if(readertokenizer.ttype == -101 && readertokenizer.sval.equals("IS"))
                {
                    if(!advance(readertokenizer))
                        return null;
                    if(readertokenizer.ttype != -101)
                        return null;
                    vrmltype.setIS(readertokenizer.sval);
                    try
                    {
                        field.set(this, vrmltype);
                        Object obj1 = field.get(this);
                    }
                    catch(Exception exception)
                    {
                        System.out.println("VRMLNode: " + exception);
                        return null;
                    }
                } else
                {
                    readertokenizer.pushBack();
                    if(!vrmltype.populate(readertokenizer))
                        return null;
                    try
                    {
                        field.set(this, vrmltype);
                    }
                    catch(Exception exception1)
                    {
                        System.out.println(exception1);
                        return null;
                    }
                }
            }
            catch(ClassCastException _ex)
            {
                try
                {
                    VRMLNode vrmlnode2 = (VRMLNode)field.getType().newInstance();
                    vrmlnode2.setVRMLNodeManager(nodeManager);
                    readertokenizer.nextToken();
                    VRMLNode vrmlnode4 = vrmlnode2.consume(readertokenizer);
                    field.set(this, vrmlnode4);
                }
                catch(Exception exception2)
                {
                    System.out.println(exception2);
                    return null;
                }
            }
            catch(InstantiationException _ex)
            {
                try
                {
                    readertokenizer.nextToken();
                    if(readertokenizer.ttype != -101)
                        return null;
                    VRMLNode vrmlnode3 = nodeManager.createNode(readertokenizer, readertokenizer.sval);
                    field.set(this, vrmlnode3);
                }
                catch(Exception exception3)
                {
                    System.out.println(exception3);
                    return null;
                }
            }
            catch(Exception exception4)
            {
                System.out.println(exception4);
                return null;
            }
        } while(true);
    }

    public void dump(PrintWriter printwriter, String s)
    {
        Field afield[] = null;
        Object obj = null;
        String s1 = myname.substring(myname.lastIndexOf(".VRML") + 5);
        try
        {
            afield = me.getDeclaredFields();
        }
        catch(Exception exception)
        {
            System.err.println("NODE dump: " + exception);
        }
        if(useName != null)
        {
            printwriter.println("USE " + useName);
            return;
        }
        if(defName != null)
            printwriter.println(s + "DEF " + defName + " " + s1 + " {");
        else
            printwriter.println(s + s1 + " {");
        String s2 = s + addedSpace;
        for(int i = 0; i < afield.length; i++)
        {
            String s3 = afield[i].getName();
            if(!s3.startsWith("_"))
                continue;
            try
            {
                obj = afield[i].get(this);
            }
            catch(Exception exception1)
            {
                System.err.println("NODE; field.get dump: " + exception1);
            }
            VRMLNode vrmlnode = null;
            Field field = null;
            VRMLType vrmltype = null;
            try
            {
                vrmlnode = (VRMLNode)Class.forName(myname).newInstance();
                field = me.getDeclaredField(s3);
                vrmltype = (VRMLType)field.get(vrmlnode);
            }
            catch(Exception exception2)
            {
                System.err.println("n = " + vrmlnode);
                System.err.println("f = " + field);
                System.err.println("v = " + vrmltype);
                System.err.println(exception2);
            }
            if(vrmltype == obj && vrmltype == null)
                continue;
            if(!nodeManager.isDebug())
                if(vrmltype != null)
                {
                    if(obj instanceof VRMLType)
                    {
                        VRMLType vrmltype1 = (VRMLType)obj;
                        if(vrmltype1.getIS() == null && vrmltype.equals(obj))
                            continue;
                    }
                } else
                if(obj == null)
                    try
                    {
                        Class class1 = Class.forName("ncsa.j3d.loaders.vrml97.MFNode");
                        if(class1.equals(field.getType()))
                            continue;
                    }
                    catch(Exception exception3)
                    {
                        System.err.println("error shouldn't have happened: " + exception3);
                    }
            printwriter.print(s2 + addedSpace + s3.substring(1) + " ");
            if(obj == null)
                printwriter.println("NULL");
            else
            if(obj instanceof VRMLNode)
            {
                VRMLNode vrmlnode1 = (VRMLNode)obj;
                vrmlnode1.dump(printwriter, s2 + addedSpace);
            } else
            if(obj instanceof MFNode)
            {
                MFNode mfnode = (MFNode)obj;
                mfnode.dump(printwriter, s2 + addedSpace);
            } else
            if(obj instanceof VRMLType)
            {
                VRMLType vrmltype2 = (VRMLType)obj;
                String s4 = vrmltype2.getIS();
                if(s4 != null)
                    printwriter.println("IS " + s4);
                else
                    vrmltype2.dump(printwriter, s2 + addedSpace);
            } else
            {
                printwriter.println(s2 + addedSpace + obj);
            }
        }

        printwriter.println(s + "}");
    }

    public String getDefName()
    {
        return defName;
    }

    public String getUSE()
    {
        return useName;
    }

    public String getWord(ReaderTokenizer readertokenizer)
    {
        if(!advance(readertokenizer))
            return null;
        if(readertokenizer.ttype != -101)
        {
            System.out.println("syntax error on line " + readertokenizer.lineno());
            return null;
        } else
        {
            return new String(readertokenizer.sval);
        }
    }

    public void setDefName(String s)
    {
        defName = s;
    }

    public void setUSE(String s)
    {
        useName = s;
    }

    public void setVRMLNodeManager(VRMLNodeManager vrmlnodemanager)
    {
        nodeManager = vrmlnodemanager;
        impl = vrmlnodemanager.getToolkitImpl();
    }

    Class me;
    String myname;
    VRMLNodeManager nodeManager;
    static String addedSpace = "  ";
    String defName;
    String useName;
    ToolkitImpl impl;

}
