/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   VRMLNodeManager.java

package ncsa.j3d.loaders.vrml97;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Vector;
import ncsa.j3d.loaders.vrml97.util.ToolkitImpl;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.vrml97:
//            VRMLNode, VRMLPROTO, VRMLViewpoint

public class VRMLNodeManager
{

    public VRMLNodeManager(ToolkitImpl toolkitimpl)
    {
        nodeVector = new Vector(10, 10);
        defTable = new Hashtable();
        protoTable = new Hashtable();
        debug = false;
        impl = null;
        impl = toolkitimpl;
    }

    public void Debug(String s)
    {
        if(debug)
            System.out.println("VRMLNodeManager: " + s);
    }

    private void addNode(VRMLNode vrmlnode)
    {
        nodeVector.addElement(vrmlnode);
    }

    public boolean advance(ReaderTokenizer readertokenizer)
    {
        try
        {
            readertokenizer.nextToken();
        }
        catch(Exception exception)
        {
            System.out.println(exception);
            return false;
        }
        return true;
    }

    public void consume(ReaderTokenizer readertokenizer, String s)
    {
        Object obj = null;
        String s1 = null;
        String s2 = null;
        s1 = s;
        if(s.equals("USE"))
        {
            String s3 = getWord(readertokenizer);
            if(s3 == null)
                return;
            VRMLNode vrmlnode1 = getDEF(s3);
            if(vrmlnode1 == null)
            {
                return;
            } else
            {
                VRMLNode vrmlnode2 = (VRMLNode)vrmlnode1.clone();
                vrmlnode2.setUSE(s3);
                addNode(vrmlnode2);
                return;
            }
        }
        if(s.equals("DEF"))
        {
            s2 = getWord(readertokenizer);
            if(s2 == null)
                return;
            s1 = getWord(readertokenizer);
            if(s1 == null)
                return;
        }
        try
        {
            obj = Class.forName(myPackage + "VRML" + s1).newInstance();
        }
        catch(ClassNotFoundException _ex)
        {
            VRMLPROTO vrmlproto = (VRMLPROTO)protoTable.get(s1);
            if(vrmlproto == null)
            {
                System.out.println("Can't find " + myPackage + "VRML" + s1);
                System.exit(10);
            }
            VRMLPROTO vrmlproto2 = (VRMLPROTO)vrmlproto.clone();
            VRMLNode vrmlnode3 = vrmlproto2.consume(readertokenizer);
            vrmlnode3.setDefName(s2);
            addNode(vrmlnode3);
            return;
        }
        catch(Exception exception)
        {
            System.out.println(exception);
            Thread.dumpStack();
            System.exit(10);
        }
        if(obj instanceof VRMLPROTO)
        {
            VRMLPROTO vrmlproto1 = null;
            try
            {
                vrmlproto1 = (VRMLPROTO)obj;
                vrmlproto1.setVRMLNodeManager(this);
                vrmlproto1.initialize(readertokenizer);
                System.out.print("PROTO ");
                System.out.println();
            }
            catch(Exception exception1)
            {
                System.out.println(exception1);
            }
            protoTable.put(vrmlproto1.getName(), vrmlproto1);
            return;
        }
        VRMLNode vrmlnode = (VRMLNode)obj;
        try
        {
            vrmlnode.setVRMLNodeManager(this);
            vrmlnode.consume(readertokenizer);
            if(s2 != null)
            {
                vrmlnode.setDefName(s2);
                defTable.put(s2, vrmlnode);
                addNode(vrmlnode);
                return;
            }
            addNode(vrmlnode);
        }
        catch(Exception exception2)
        {
            System.out.println(exception2);
            System.exit(10);
        }
    }

    public VRMLNode createNode(ReaderTokenizer readertokenizer, String s)
    {
        Object obj = null;
        String s1 = null;
        String s2 = null;
        s1 = s;
        if(s.equals("USE"))
        {
            String s3 = getWord(readertokenizer);
            if(s3 == null)
                return null;
            VRMLNode vrmlnode = getDEF(s3);
            if(vrmlnode == null)
            {
                return null;
            } else
            {
                VRMLNode vrmlnode3 = (VRMLNode)vrmlnode.clone();
                vrmlnode3.setUSE(s3);
                return vrmlnode3;
            }
        }
        if(s.equals("DEF"))
        {
            s2 = getWord(readertokenizer);
            if(s2 == null)
                return null;
            s1 = getWord(readertokenizer);
            if(s1 == null)
                return null;
        }
        if(s.equals("NULL"))
            return null;
        VRMLPROTO vrmlproto;
        try
        {
            VRMLNode vrmlnode1 = (VRMLNode)Class.forName(myPackage + "VRML" + s1).newInstance();
            vrmlnode1.setVRMLNodeManager(this);
            VRMLNode vrmlnode2 = vrmlnode1.consume(readertokenizer);
            if(s2 != null)
            {
                vrmlnode2.setDefName(s2);
                defTable.put(s2, vrmlnode2);
                return vrmlnode2;
            } else
            {
                return vrmlnode2;
            }
        }
        catch(ClassNotFoundException _ex)
        {
            vrmlproto = (VRMLPROTO)protoTable.get(s);
        }
        catch(Exception _ex)
        {
            return null;
        }
        if(vrmlproto == null)
        {
            System.out.println("Unknown keyword \"" + s + "\" on line " + readertokenizer.lineno());
            return null;
        } else
        {
            VRMLPROTO vrmlproto1 = (VRMLPROTO)vrmlproto.clone();
            VRMLNode vrmlnode4 = vrmlproto1.consume(readertokenizer);
            return vrmlnode4;
        }
    }

    public void dump(PrintWriter printwriter)
    {
        for(int i = 0; i < nodeVector.size(); i++)
        {
            VRMLNode vrmlnode = (VRMLNode)nodeVector.elementAt(i);
            vrmlnode.dump(printwriter, "");
        }

    }

    public VRMLNode getDEF(String s)
    {
        VRMLNode vrmlnode = (VRMLNode)defTable.get(s);
        if(vrmlnode == null)
            return null;
        else
            return vrmlnode;
    }

    public Field getField(VRMLNode vrmlnode, String s)
    {
        Field field = null;
        Class class1 = vrmlnode.getClass();
        try
        {
            field = class1.getDeclaredField("_" + s);
        }
        catch(Exception _ex)
        {
            return null;
        }
        return field;
    }

    public Vector getNodes()
    {
        return nodeVector;
    }

    public String getPackageName()
    {
        return myPackage;
    }

    public ToolkitImpl getToolkitImpl()
    {
        return impl;
    }

    public VRMLViewpoint getViewpoint()
    {
        if(debug)
            System.out.println("nodeVector.size() = " + nodeVector.size());
        for(int i = 0; i < nodeVector.size(); i++)
        {
            VRMLNode vrmlnode = (VRMLNode)nodeVector.elementAt(i);
            if(debug)
                System.out.println("n = " + vrmlnode);
            if(vrmlnode instanceof VRMLViewpoint)
                return (VRMLViewpoint)vrmlnode;
        }

        return null;
    }

    public String getWord(ReaderTokenizer readertokenizer)
    {
        if(!advance(readertokenizer))
            return null;
        if(readertokenizer.ttype != -101)
        {
            System.out.println("syntax error on line " + readertokenizer.lineno());
            return null;
        } else
        {
            return new String(readertokenizer.sval);
        }
    }

    public boolean isDebug()
    {
        return debug;
    }

    public void setDebug(boolean flag)
    {
        debug = flag;
    }

    Vector nodeVector;
    Hashtable defTable;
    Hashtable protoTable;
    boolean debug;
    static String myPackage = "ncsa.j3d.loaders.vrml97.";
    ToolkitImpl impl;

}
