/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   VRMLPROTO.java

package ncsa.j3d.loaders.vrml97;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.vrml97:
//            VRMLNode, Declaration, VRMLNodeManager, VRMLType

public class VRMLPROTO extends VRMLNode
    implements Cloneable
{

    public VRMLPROTO()
    {
        declarations = new Vector(5, 5);
        nodes = new Vector(5, 5);
        is = new Vector(5, 5);
        definitionDumped = false;
    }

    public Object clone()
    {
        try
        {
            VRMLPROTO vrmlproto = (VRMLPROTO)super.clone();
            vrmlproto.declarations = (Vector)declarations.clone();
            vrmlproto.nodes = (Vector)nodes.clone();
            int i = vrmlproto.declarations.size();
            for(int j = 0; j < i; j++)
            {
                Declaration declaration = (Declaration)declarations.elementAt(j);
                Declaration declaration1 = (Declaration)declaration.clone();
                vrmlproto.declarations.setElementAt(declaration1, j);
            }

            i = vrmlproto.nodes.size();
            for(int k = 0; k < i; k++)
            {
                VRMLNode vrmlnode = (VRMLNode)nodes.elementAt(k);
                VRMLNode vrmlnode1 = (VRMLNode)vrmlnode.clone();
                vrmlproto.nodes.setElementAt(vrmlnode1, k);
            }

            return vrmlproto;
        }
        catch(Exception exception)
        {
            System.out.println("Exception " + exception);
            exception.printStackTrace();
            return null;
        }
    }

    public VRMLNode consume(ReaderTokenizer readertokenizer)
    {
        Debug("VRMLNode: 1 st.ttype = " + readertokenizer.ttype);
        Debug("VRMLNode: 1 st.sval = " + readertokenizer.sval);
        if(readertokenizer.ttype == -101)
        {
            if(readertokenizer.sval.equals("DEF"))
            {
                VRMLNode vrmlnode = super.nodeManager.createNode(readertokenizer, "DEF");
                return vrmlnode;
            }
            if(readertokenizer.sval.equals("USE"))
            {
                String s = getWord(readertokenizer);
                if(s == null)
                    return null;
                VRMLNode vrmlnode1 = super.nodeManager.getDEF(s);
                if(vrmlnode1 == null)
                {
                    return null;
                } else
                {
                    VRMLNode vrmlnode2 = (VRMLNode)vrmlnode1.clone();
                    vrmlnode2.setUSE(s);
                    return vrmlnode2;
                }
            }
            if(readertokenizer.sval.equals("NULL"))
                return null;
        }
        if(!advance(readertokenizer))
            return null;
        if(readertokenizer.ttype != 123)
        {
            Debug("2 st.ttype = " + readertokenizer.ttype);
            Debug("2 st.sval = " + readertokenizer.sval);
            System.out.println("1a error at " + readertokenizer.lineno());
            return null;
        }
        do
        {
            if(!advance(readertokenizer))
                return null;
            if(readertokenizer.ttype == 125)
            {
                Debug("Done! this = " + this);
                return this;
            }
            if(readertokenizer.ttype != -101)
            {
                Debug("4 " + readertokenizer.sval + " " + readertokenizer.ttype);
                return null;
            }
            Debug("TOP: st.sval = " + readertokenizer.sval);
            Declaration declaration = getDecl(readertokenizer.sval);
            if(declaration == null)
            {
                Debug("st.sval = " + readertokenizer.sval);
                System.out.println("VRMLPROTO: 1b error at " + readertokenizer.lineno());
                return null;
            }
            Debug("myDecl = " + declaration.getName());
            Debug("myDecl.getType = " + declaration.getType());
            try
            {
                if(!advance(readertokenizer))
                    return null;
                if(readertokenizer.ttype == -101 && readertokenizer.sval.equals("IS"))
                {
                    if(!advance(readertokenizer))
                        return null;
                    if(readertokenizer.ttype != -101)
                        return null;
                    System.out.println("IS " + readertokenizer.sval);
                    VRMLType vrmltype = declaration.getType();
                    vrmltype.setIS(readertokenizer.sval);
                    System.out.println(String.valueOf(vrmltype) + " IS " + readertokenizer.sval);
                } else
                {
                    readertokenizer.pushBack();
                    Debug("VRMLPROTO: populating");
                    VRMLType vrmltype1 = declaration.getType();
                    if(!vrmltype1.populate(readertokenizer))
                    {
                        Debug("5");
                        Debug("in " + super.myname + " type = " + vrmltype1);
                        return null;
                    }
                }
            }
            catch(Exception exception)
            {
                Debug("4b");
                System.out.println(exception);
                return null;
            }
        } while(true);
    }

    Declaration createDecl(ReaderTokenizer readertokenizer, String s)
    {
        Debug("createDecl: name = " + s);
        Declaration declaration = null;
        try
        {
            declaration = (Declaration)Class.forName(VRMLNodeManager.myPackage + s).newInstance();
        }
        catch(Exception exception)
        {
            System.out.println("createDecl:  create failed: " + exception);
        }
        declaration.populate(readertokenizer);
        return declaration;
    }

    public void dump(PrintWriter printwriter, String s)
    {
        if(definitionDumped)
        {
            printwriter.println(s + protoName + " {");
            for(int i = 0; i < declarations.size(); i++)
            {
                Declaration declaration = (Declaration)declarations.elementAt(i);
                declaration.dumpPartial(printwriter, s + "   ");
            }

            printwriter.println(s + "}");
            return;
        }
        printwriter.println(s + protoName + " [");
        for(int j = 0; j < declarations.size(); j++)
        {
            Declaration declaration1 = (Declaration)declarations.elementAt(j);
            declaration1.dump(printwriter, s + "   ");
        }

        printwriter.println(s + "]");
        printwriter.println(s + "{");
        for(int k = 0; k < nodes.size(); k++)
        {
            VRMLNode vrmlnode = (VRMLNode)nodes.elementAt(k);
            vrmlnode.dump(printwriter, s + "   ");
        }

        printwriter.println(s + "}");
        definitionDumped = true;
    }

    public Declaration getDecl(String s)
    {
        int i = declarations.size();
        for(int j = 0; j < i; j++)
        {
            Declaration declaration = (Declaration)declarations.elementAt(j);
            if(declaration.getName().equals(s))
                return declaration;
        }

        return null;
    }

    public String getName()
    {
        return protoName;
    }

    public VRMLPROTO initialize(ReaderTokenizer readertokenizer)
    {
        if((protoName = getWord(readertokenizer)) == null)
            return null;
        Debug("VRMLPROTO: protoName = " + protoName);
        if(!advance(readertokenizer))
            return null;
        Debug("VRMLPROTO: 1 st.sval = " + readertokenizer.sval);
        if(readertokenizer.ttype != 91)
        {
            System.out.print("Syntax error on line " + readertokenizer.lineno() + ": ");
            System.out.println("expecting '['");
            return null;
        }
        if(!advance(readertokenizer))
            return null;
        Debug("VRMLPROTO: 2 st.sval = " + readertokenizer.sval);
        while(readertokenizer.ttype != 93) 
        {
            Debug("VRMLPROTO: 2a st.sval = " + readertokenizer.sval);
            try
            {
                Debug("VRMLPROTO: 3 st.sval = " + readertokenizer.sval);
                Declaration declaration = createDecl(readertokenizer, readertokenizer.sval);
                if(declaration == null)
                    return null;
                declarations.addElement(declaration);
            }
            catch(Exception _ex)
            {
                System.out.print("Syntax error on line " + readertokenizer.lineno() + ": ");
                System.out.println("expected field, eventIn, eventOut, or exposedField");
                return null;
            }
            if(!advance(readertokenizer))
                return null;
        }
        if(!advance(readertokenizer))
            return null;
        if(readertokenizer.ttype != 123)
        {
            System.out.print("Syntax error on line " + readertokenizer.lineno() + ": ");
            System.out.println("expecting '{': st.sval = " + readertokenizer.sval + " st.nval " + readertokenizer.nval);
            return null;
        }
        if(!advance(readertokenizer))
            return null;
        Debug("st.ttype = " + readertokenizer.ttype + " st.sval = " + readertokenizer.sval + " st.nval " + readertokenizer.nval);
        while(readertokenizer.ttype != 125) 
        {
            try
            {
                VRMLNode vrmlnode = super.nodeManager.createNode(readertokenizer, readertokenizer.sval);
                if(vrmlnode == null)
                    return null;
                nodes.addElement(vrmlnode);
            }
            catch(Exception _ex)
            {
                System.out.print("Syntax error on line " + readertokenizer.lineno() + ": ");
                System.out.println("Invalid VRMLNode name");
                return null;
            }
            if(!advance(readertokenizer))
                return null;
        }
        Debug("VRMLPROTO: protoName " + protoName + " returning");
        return this;
    }

    String protoName;
    Vector declarations;
    Vector nodes;
    Vector is;
    boolean definitionDumped;
}
