/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   VRMLScript.java

package ncsa.j3d.loaders.vrml97;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.media.j3d.Group;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.vrml97:
//            VRMLNode, ChildNode, Declaration, MFString, 
//            SFBool, VRMLNodeManager, VRMLPROTO, VRMLType

public class VRMLScript extends VRMLNode
    implements Cloneable, ChildNode
{

    public VRMLScript()
    {
        declarations = new Vector(5, 5);
        is = new Vector(5, 5);
        _url = null;
        _directOutput = new SFBool(false);
        _mustEvaluate = new SFBool(false);
        debug = true;
    }

    public Object clone()
    {
        try
        {
            VRMLPROTO vrmlproto = (VRMLPROTO)super.clone();
            vrmlproto.declarations = (Vector)declarations.clone();
            int i = vrmlproto.declarations.size();
            for(int j = 0; j < i; j++)
            {
                Declaration declaration = (Declaration)declarations.elementAt(j);
                Declaration declaration1 = (Declaration)declaration.clone();
                vrmlproto.declarations.setElementAt(declaration1, j);
            }

            return vrmlproto;
        }
        catch(Exception exception)
        {
            System.out.println("Exception " + exception);
            exception.printStackTrace();
            return null;
        }
    }

    public VRMLNode consume(ReaderTokenizer readertokenizer)
    {
        if(!advance(readertokenizer))
            return null;
        if(readertokenizer.ttype != 123)
        {
            System.out.print("Syntax error on line " + readertokenizer.lineno() + ": ");
            System.out.println("expecting '{'");
            return null;
        }
        if(!advance(readertokenizer))
            return null;
        while(readertokenizer.ttype != 125) 
        {
            if(readertokenizer.ttype != -101)
            {
                System.out.println("Syntax error on line " + readertokenizer.lineno());
                return null;
            }
            Debug("st.sval = " + readertokenizer.sval);
            Field field = super.nodeManager.getField(this, readertokenizer.sval);
            if(field == null)
            {
                try
                {
                    Debug("st.sval");
                    Declaration declaration = createDecl(readertokenizer, readertokenizer.sval);
                    if(declaration == null)
                        return null;
                    Debug("adding decl = " + declaration);
                    declarations.addElement(declaration);
                }
                catch(Exception _ex)
                {
                    System.out.print("Syntax error on line " + readertokenizer.lineno() + ": ");
                    System.out.println("expected field, eventIn, eventOut, or exposedField");
                    return null;
                }
            } else
            {
                Object obj = null;
                try
                {
                    VRMLType vrmltype = (VRMLType)field.getType().newInstance();
                    vrmltype.setVRMLNodeManager(super.nodeManager);
                    if(!advance(readertokenizer))
                        return null;
                    int _tmp = readertokenizer.ttype;
                    readertokenizer.pushBack();
                    if(!vrmltype.populate(readertokenizer))
                        return null;
                    try
                    {
                        field.set(this, vrmltype);
                    }
                    catch(Exception exception)
                    {
                        System.out.println(exception);
                        return null;
                    }
                }
                catch(Exception exception1)
                {
                    System.out.println(exception1);
                    return null;
                }
            }
            if(!advance(readertokenizer))
                return null;
        }
        return this;
    }

    Declaration createDecl(ReaderTokenizer readertokenizer, String s)
    {
        Declaration declaration = null;
        try
        {
            declaration = (Declaration)Class.forName(VRMLNodeManager.myPackage + s).newInstance();
        }
        catch(Exception exception)
        {
            System.out.println("createDecl:  create failed: " + exception);
        }
        declaration.populate(readertokenizer);
        return declaration;
    }

    public void dump(PrintWriter printwriter, String s)
    {
        if(super.defName != null)
            printwriter.println(s + "DEF " + super.defName + " " + super.myname + " {");
        else
            printwriter.println(s + super.myname + " {");
        for(int i = 0; i < declarations.size(); i++)
        {
            Declaration declaration = (Declaration)declarations.elementAt(i);
            declaration.dump(printwriter, s + "   ");
        }

        if(_directOutput.equals(new SFBool(true)))
            printwriter.println(s + "   directOutput TRUE");
        if(_mustEvaluate.equals(new SFBool(true)))
            printwriter.println(s + "   mustEvaluate TRUE");
        if(_url != null)
        {
            printwriter.print(s + "   url ");
            _url.dump(printwriter, "");
            printwriter.println();
        }
        printwriter.println(s + "}");
    }

    public Declaration getDecl(String s)
    {
        int i = declarations.size();
        for(int j = 0; j < i; j++)
        {
            Declaration declaration = (Declaration)declarations.elementAt(j);
            if(declaration.getName().equals(s))
                return declaration;
        }

        return null;
    }

    public Group produceChild()
    {
        return null;
    }

    Vector declarations;
    Vector is;
    MFString _url;
    SFBool _directOutput;
    SFBool _mustEvaluate;
    boolean debug;
}
