/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   J3DAnchor.java

package ncsa.j3d.loaders.vrml97.j3d;

import java.io.PrintStream;
import javax.media.j3d.*;
import javax.vecmath.Point3d;
import ncsa.j3d.loaders.vrml97.*;
import ncsa.j3d.loaders.vrml97.util.ToolkitGroup;

// Referenced classes of package ncsa.j3d.loaders.vrml97.j3d:
//            AnchorGroup, J3DGroup, J3DShape

public class J3DAnchor
    implements ToolkitGroup
{

    public J3DAnchor()
    {
        group = null;
        description = null;
        parameter = null;
        url = null;
        anchor = null;
    }

    public J3DAnchor(VRMLAnchor vrmlanchor)
    {
        group = null;
        description = null;
        parameter = null;
        url = null;
        anchor = null;
        produceAnchor(vrmlanchor);
    }

    public Group getGroup()
    {
        return group;
    }

    public void produceAnchor(VRMLAnchor vrmlanchor)
    {
        anchor = vrmlanchor;
        MFNode mfnode = vrmlanchor.getChildren();
        group = new AnchorGroup();
        group.setCapability(1);
        group.setCapability(5);
        group.setCapability(3);
        group.setCapability(4);
        group.setDescription(vrmlanchor.getDescription());
        group.setURL(vrmlanchor.getURL());
        group.setParameter(vrmlanchor.getParameter());
        int i = mfnode.getSize();
        BoundingSphere boundingsphere = new BoundingSphere(new Point3d(0.0D, 0.0D, 0.0D), 0.0D);
        for(int j = 0; j < i; j++)
        {
            ncsa.j3d.loaders.vrml97.VRMLNode vrmlnode = mfnode.getElement(j);
            if(vrmlnode instanceof VRMLShape)
            {
                VRMLShape vrmlshape = (VRMLShape)vrmlnode;
                J3DShape j3dshape = (J3DShape)vrmlshape.produceShape();
                if(j3dshape != null)
                {
                    Group group2 = j3dshape.getShape();
                    if(group2 != null)
                    {
                        Bounds bounds = group2.getBounds();
                        boundingsphere.combine(bounds);
                        group.addChild(group2);
                    }
                }
            } else
            if(vrmlnode instanceof GroupingNode)
            {
                J3DGroup j3dgroup = new J3DGroup((GroupingNode)vrmlnode);
                Group group1 = j3dgroup.getGroup();
                if(group1 != null)
                    group.addChild(group1);
                else
                    System.out.println("Anchor: newGroup = " + group1);
            }
        }

        group.setBounds(boundingsphere);
    }

    AnchorGroup group;
    String description;
    String parameter[];
    String url[];
    float bboxCenterX;
    float bboxCenterY;
    float bboxCenterZ;
    float bboxSizeX;
    float bboxSizeY;
    float bboxSizeZ;
    VRMLAnchor anchor;
}
