/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   J3DAppearance.java

package ncsa.j3d.loaders.vrml97.j3d;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;
import ncsa.j3d.loaders.vrml97.*;

public class J3DAppearance
{

    public J3DAppearance(VRMLAppearance vrmlappearance)
    {
        material = null;
        appearance = null;
        app = vrmlappearance;
        appearance = new Appearance();
        appearance.setCapability(0);
        appearance.setCapability(10);
        appearance.setCapability(11);
        VRMLMaterial vrmlmaterial = vrmlappearance.getMaterial();
        material = getJ3DMaterial(vrmlmaterial);
        if(material != null)
            appearance.setMaterial(material);
        if(vrmlmaterial != null)
        {
            float f = vrmlmaterial.getTransparency().getValue();
            if((double)f > 0.0D)
            {
                TransparencyAttributes transparencyattributes = new TransparencyAttributes(1, f);
                transparencyattributes.setCapability(2);
                transparencyattributes.setCapability(3);
                appearance.setTransparencyAttributes(transparencyattributes);
            }
        }
        RenderingAttributes renderingattributes = new RenderingAttributes();
        renderingattributes.setDepthBufferEnable(true);
        appearance.setRenderingAttributes(renderingattributes);
    }

    public Appearance getAppearance()
    {
        return appearance;
    }

    public Color3f getColor3f(SFColor sfcolor)
    {
        return new Color3f(sfcolor.getRed(), sfcolor.getGreen(), sfcolor.getBlue());
    }

    public Material getJ3DMaterial(VRMLMaterial vrmlmaterial)
    {
        if(vrmlmaterial == null)
        {
            return null;
        } else
        {
            Color3f color3f = getColor3f(vrmlmaterial.getEmissiveColor());
            Color3f color3f1 = getColor3f(vrmlmaterial.getDiffuseColor());
            Color3f color3f2 = getColor3f(vrmlmaterial.getSpecularColor());
            float f = vrmlmaterial.getShininess().getValue();
            f = f * 127F + 1.0F;
            float f1 = vrmlmaterial.getAmbientIntensity().getValue();
            Color3f color3f3 = new Color3f(color3f1);
            color3f3.scale(f1);
            Material material1 = new Material(color3f3, color3f, color3f1, color3f2, f);
            material1.setCapability(0);
            material1.setLightingEnable(true);
            return material1;
        }
    }

    public void setLightingEnable(boolean flag)
    {
        if(material != null)
        {
            material.setLightingEnable(flag);
            appearance.setMaterial(material);
        }
    }

    Material material;
    GeometryArray g;
    VRMLAppearance app;
    Appearance appearance;
}
