/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   J3DGroup.java

package ncsa.j3d.loaders.vrml97.j3d;

import java.io.PrintStream;
import java.util.Vector;
import javax.media.j3d.*;
import ncsa.j3d.loaders.vrml97.*;
import ncsa.j3d.loaders.vrml97.util.ToolkitGroup;

// Referenced classes of package ncsa.j3d.loaders.vrml97.j3d:
//            J3DAnchor, J3DShape, J3DTransform

public class J3DGroup
    implements ToolkitGroup
{
    class DefPair
    {

        String name;
        Object obj;

        public DefPair(String s, Object obj1)
        {
            name = s;
            obj = obj1;
        }
    }


    public J3DGroup()
    {
        group = null;
        debug = false;
        defList = null;
    }

    public J3DGroup(GroupingNode groupingnode)
    {
        group = null;
        debug = false;
        defList = null;
        produceGroup(groupingnode);
    }

    private void addDefName(String s, Object obj)
    {
        if(defList == null)
            defList = new Vector();
        defList.addElement(new DefPair(s, obj));
    }

    public Group getGroup()
    {
        return group;
    }

    public Node getNamedObject(String s)
    {
        if(defList == null)
            return null;
        for(int i = 0; i < defList.size(); i++)
        {
            DefPair defpair = (DefPair)defList.elementAt(i);
            if(defpair.name.equals(GROUP_MAGIC_TAG))
            {
                J3DGroup j3dgroup = (J3DGroup)defpair.obj;
                Node node = j3dgroup.getNamedObject(s);
                if(node != null)
                    return (Node)node;
            } else
            if(defpair.name.equals(s))
                return (Node)defpair.obj;
        }

        return null;
    }

    public void produceChild(ChildNode childnode)
    {
        Thread.dumpStack();
        System.exit(0);
    }

    public void produceGroup(GroupingNode groupingnode)
    {
        MFNode mfnode = groupingnode.getChildren();
        Object obj = null;
        if(mfnode == null)
            return;
        group = new Group();
        group.setCapability(12);
        int i = mfnode.getSize();
        for(int j = 0; j < i; j++)
        {
            ncsa.j3d.loaders.vrml97.VRMLNode vrmlnode = mfnode.getElement(j);
            if(vrmlnode instanceof VRMLShape)
            {
                VRMLShape vrmlshape = (VRMLShape)vrmlnode;
                J3DShape j3dshape = (J3DShape)vrmlshape.produceShape();
                if(j3dshape != null)
                {
                    Group group1 = j3dshape.getShape();
                    if(group1 != null)
                    {
                        group.addChild(group1);
                        String s = j3dshape.getDefName();
                        if(s != null)
                            addDefName(s, group1);
                    }
                }
            } else
            if(vrmlnode instanceof VRMLAnchor)
            {
                J3DAnchor j3danchor = new J3DAnchor((VRMLAnchor)vrmlnode);
                Group group2 = j3danchor.getGroup();
                if(group2 != null)
                    group.addChild(group2);
            } else
            if(vrmlnode instanceof VRMLTransform)
            {
                J3DTransform j3dtransform = new J3DTransform((VRMLTransform)vrmlnode);
                Group group3 = j3dtransform.getGroup();
                if(group3 != null)
                    group.addChild(group3);
                else
                if(debug)
                    System.out.println("Group: newGroup == null!");
            } else
            if(vrmlnode instanceof GroupingNode)
            {
                if(debug)
                    System.out.println("Group: working on node = " + vrmlnode);
                J3DGroup j3dgroup = new J3DGroup((GroupingNode)vrmlnode);
                Group group4 = j3dgroup.getGroup();
                if(group4 != null)
                {
                    group.addChild(group4);
                    addDefName(GROUP_MAGIC_TAG, j3dgroup);
                } else
                if(debug)
                    System.out.println("Group: newGroup == null!");
            } else
            if(debug)
                System.out.println("Group: " + vrmlnode + " not implemented");
        }

    }

    Group group;
    boolean debug;
    Vector defList;
    static String GROUP_MAGIC_TAG = new String("J3D__Group__");

}
