/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   J3DIndexedFaceSet.java

package ncsa.j3d.loaders.vrml97.j3d;

import java.io.PrintStream;
import javax.media.j3d.*;
import javax.vecmath.*;
import ncsa.j3d.loaders.vrml97.*;
import ncsa.vecmath.IndexedPolygon;

// Referenced classes of package ncsa.j3d.loaders.vrml97.j3d:
//            J3DShape, J3DAppearance

public class J3DIndexedFaceSet extends J3DShape
{

    public J3DIndexedFaceSet(VRMLShape vrmlshape)
    {
        surfNormals = new Vector3f[100];
        surfNormalIndex = 0;
        pointNormals = new Vector3f[100];
        pointNormalIndex = 0;
        tri = null;
        indexedPolygon = null;
        coordIndex = null;
        coords = null;
        pointIndices = null;
        bounds = null;
        super.appearance = vrmlshape.getAppearance();
        if(super.appearance != null)
        {
            J3DAppearance j3dappearance = new J3DAppearance(super.appearance);
            j3dappearance.setLightingEnable(true);
            super.app = j3dappearance.getAppearance();
        } else
        {
            super.app = new Appearance();
            super.app.setCapability(0);
        }
        super.geometry = vrmlshape.getGeometry();
        VRMLIndexedFaceSet vrmlindexedfaceset = (VRMLIndexedFaceSet)super.geometry;
        if(!vrmlindexedfaceset.getSolid())
        {
            PolygonAttributes polygonattributes = new PolygonAttributes();
            polygonattributes.setCullFace(0);
            polygonattributes.setBackFaceNormalFlip(true);
            super.app.setPolygonAttributes(polygonattributes);
        }
        super.g = buildIndexedFaceSet();
        super.shape3D = new Shape3D(super.g, super.app);
        super.shape3D.setCapability(14);
        super.shape3D.setCapability(12);
        super.shape3D.setCapability(3);
        super.shape3D.setCapability(4);
        super.shape3D.setUserData(bounds);
    }

    private GeometryArray buildIndexedFaceSet()
    {
        VRMLIndexedFaceSet vrmlindexedfaceset = (VRMLIndexedFaceSet)super.geometry;
        VRMLCoordinate vrmlcoordinate = vrmlindexedfaceset.getCoordinate();
        coordIndex = vrmlindexedfaceset.getCoordIndex();
        MFVec3f mfvec3f = vrmlcoordinate.getPoint();
        int i = vrmlcoordinate.getSize();
        Point3d apoint3d[] = new Point3d[i];
        byte byte0 = -1;
        for(int k = 0; k < i; k++)
        {
            SFVec3f sfvec3f = mfvec3f.getElement(k);
            Point3f point3f = new Point3f(sfvec3f.getX(), sfvec3f.getY(), sfvec3f.getZ());
            apoint3d[k] = new Point3d(point3f);
        }

        bounds = new BoundingBox(apoint3d[0], apoint3d[0]);
        bounds.combine(apoint3d);
        boolean flag = false;
        byte byte1 = -1;
        if(coordIndex != null)
        {
            int l = coordIndex.getSize();
            coords = new int[l];
            for(int i1 = 0; i1 < l; i1++)
                coords[i1] = coordIndex.getElement(i1);

            int j = countDelimiters(coords);
            pointIndices = new int[j][];
            Object obj = null;
            int j1 = 0;
            int l1;
            for(int k1 = 0; k1 < l; k1 += l1 + 1)
            {
                l1 = calcDelimitedSize(k1, coords);
                int ai[] = new int[l1];
                for(int i2 = 0; i2 < l1; i2++)
                    ai[i2] = coords[k1 + i2];

                pointIndices[j1++] = ai;
            }

            indexedPolygon = new IndexedPolygon(apoint3d, pointIndices);
        }
        setNormals(vrmlindexedfaceset);
        setColors(vrmlindexedfaceset);
        tri = indexedPolygon.getIndexedTriangleArray();
        return tri;
    }

    private int calcDelimitedSize(int i, int ai[])
    {
        int j = 0;
        for(int k = i; k < ai.length; k++)
        {
            if(ai[k] == -1)
                return j;
            j++;
        }

        return j;
    }

    public Color3f convertColor(SFColor sfcolor)
    {
        return new Color3f(sfcolor.getRed(), sfcolor.getGreen(), sfcolor.getBlue());
    }

    private int countDelimiters(int ai[])
    {
        int i = 0;
        for(int j = 0; j < ai.length; j++)
            if(ai[j] == -1)
                i++;

        return i;
    }

    private void setColors(VRMLIndexedFaceSet vrmlindexedfaceset)
    {
        MFInt32 mfint32 = vrmlindexedfaceset.getColorIndex();
        int i = -1;
        boolean flag = vrmlindexedfaceset.getColorPerVertex();
        MFInt32 mfint32_1 = vrmlindexedfaceset.getCoordIndex();
        int j = -1;
        boolean flag1 = false;
        VRMLColor vrmlcolor = vrmlindexedfaceset.getColor();
        if(vrmlcolor == null)
            return;
        MFColor mfcolor = vrmlcolor.getColor();
        int k = mfcolor.getSize();
        if(mfint32 != null)
        {
            i = mfint32.getSize();
            if(i == 0)
            {
                mfint32 = null;
                i = -1;
            }
        }
        Color3f acolor3f[] = new Color3f[k];
        for(int l = 0; l < k; l++)
            acolor3f[l] = convertColor(mfcolor.getElement(l));

        if(mfint32_1 != null)
            j = mfint32_1.getSize();
        Object obj = null;
        if(i == -1)
        {
            int ai[] = new int[j];
            for(int i1 = 0; i1 < j; i1++)
                ai[i1] = mfint32_1.getElement(i1);

            flag1 = true;
        } else
        {
            int ai1[] = new int[i];
            for(int j1 = 0; j1 < i; j1++)
                ai1[j1] = mfint32.getElement(j1);

        }
        int k1 = countDelimiters(coords);
        int ai2[][] = new int[k1][];
        if(flag)
        {
            int l1 = 0;
            int j2 = 0;
            boolean flag3 = false;
            for(int l3 = 0; l3 < pointIndices.length; l3++)
            {
                int i3 = pointIndices[l3].length;
                int ai3[] = new int[i3];
                for(int k4 = 0; k4 < i3; k4++)
                {
                    int j5;
                    if(flag1)
                        j5 = mfint32_1.getElement(j2++);
                    else
                        j5 = mfint32.getElement(j2++);
                    ai3[k4] = j5;
                }

                j2++;
                ai2[l1++] = ai3;
            }

        } else
        {
            int i2 = 0;
            boolean flag2 = false;
            if(flag1)
            {
                for(int j3 = 0; j3 < j; j3++)
                {
                    int i4 = mfint32_1.getElement(j3);
                    int k2 = pointIndices[j3].length;
                    int ai4[] = new int[k2];
                    for(int l4 = 0; l4 < k2; l4++)
                        ai4[l4] = i4;

                    ai2[i2++] = ai4;
                }

            } else
            {
                for(int k3 = 0; k3 < i; k3++)
                {
                    int j4 = mfint32.getElement(k3);
                    int l2 = pointIndices[k3].length;
                    int ai5[] = new int[l2];
                    for(int i5 = 0; i5 < l2; i5++)
                        ai5[i5] = j4;

                    ai2[i2++] = ai5;
                }

            }
        }
        indexedPolygon.setColors(acolor3f, ai2);
    }

    private void setNormals(VRMLIndexedFaceSet vrmlindexedfaceset)
    {
        VRMLNormal vrmlnormal = vrmlindexedfaceset.getNormal();
        if(vrmlnormal == null)
            return;
        MFVec3f mfvec3f = vrmlnormal.getNormals();
        if(mfvec3f == null)
            return;
        MFInt32 mfint32 = vrmlindexedfaceset.getNormalIndex();
        if(mfint32 != null && mfint32.getSize() != 0)
        {
            System.out.println("normalIndex = " + mfint32);
            System.out.println("normal Index specified.");
            System.out.println("that feature is unimplemented");
            System.exit(0);
            return;
        }
        if(coordIndex == null)
        {
            System.out.println("normals specified, but no normalIndex or coordIndex specified.");
            return;
        }
        Vector3f avector3f[] = new Vector3f[mfvec3f.getSize()];
        for(int i = 0; i < mfvec3f.getSize(); i++)
        {
            SFVec3f sfvec3f = mfvec3f.getElement(i);
            avector3f[i] = new Vector3f(sfvec3f.x, sfvec3f.y, sfvec3f.z);
        }

        indexedPolygon.setNormals(avector3f, pointIndices);
    }

    private Vector3f surfNormals[];
    private int surfNormalIndex;
    private Vector3f pointNormals[];
    private int pointNormalIndex;
    IndexedGeometryArray tri;
    IndexedPolygon indexedPolygon;
    MFInt32 coordIndex;
    int coords[];
    int pointIndices[][];
    BoundingBox bounds;
}
