/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   J3DIndexedLineSet.java

package ncsa.j3d.loaders.vrml97.j3d;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import ncsa.j3d.loaders.vrml97.*;

// Referenced classes of package ncsa.j3d.loaders.vrml97.j3d:
//            J3DShape

public class J3DIndexedLineSet extends J3DShape
{

    public J3DIndexedLineSet(VRMLShape vrmlshape)
    {
        super(vrmlshape);
        set = new Point3d[1000];
        setIndex = 0;
        noAppearance = false;
        defName = null;
        bounds = null;
        VRMLMaterial vrmlmaterial = super.appearance.getMaterial();
        GeometryArray geometryarray = buildIndexedLineSet(vrmlmaterial);
        if(noAppearance)
        {
            super.app = new Appearance();
            super.app.setCapability(0);
            super.app.setCapability(10);
            super.app.setCapability(11);
            TransparencyAttributes transparencyattributes = new TransparencyAttributes();
            transparencyattributes.setCapability(2);
            transparencyattributes.setCapability(3);
            super.app.setTransparencyAttributes(transparencyattributes);
            Material material1 = new Material();
            material1.setCapability(0);
            Color3f color3f = getColor3f(vrmlmaterial.getEmissiveColor());
            material1.setEmissiveColor(color3f);
            material1.setShininess(26.4F);
            material1.setLightingEnable(false);
            super.app.setMaterial(material1);
            RenderingAttributes renderingattributes = new RenderingAttributes();
            renderingattributes.setDepthBufferEnable(true);
            super.app.setRenderingAttributes(renderingattributes);
        } else
        {
            Material material = super.app.getMaterial();
            material.setLightingEnable(false);
            super.app.setMaterial(material);
        }
        super.shape3D = new Shape3D(geometryarray, super.app);
        super.shape3D.setCapability(14);
        super.shape3D.setCapability(12);
        super.shape3D.setCapability(3);
        super.shape3D.setCapability(4);
        super.shape3D.setUserData(bounds);
        defName = vrmlshape.getDefName();
    }

    private void addLine(Point3d point3d, Point3d point3d1)
    {
        if(set.length - setIndex < 2)
        {
            Point3d apoint3d[] = new Point3d[set.length * 2];
            System.arraycopy(set, 0, apoint3d, 0, set.length);
            set = apoint3d;
        }
        set[setIndex++] = point3d;
        set[setIndex++] = point3d1;
    }

    public GeometryArray buildIndexedLineSet(VRMLMaterial vrmlmaterial)
    {
        VRMLIndexedLineSet vrmlindexedlineset = (VRMLIndexedLineSet)super.geometry;
        VRMLCoordinate vrmlcoordinate = vrmlindexedlineset.getCoordinate();
        MFInt32 mfint32 = vrmlindexedlineset.getCoordIndex();
        MFVec3f mfvec3f = vrmlcoordinate.getPoint();
        int i = vrmlcoordinate.getSize();
        Point3d apoint3d[] = new Point3d[i];
        boolean flag = false;
        boolean flag1 = vrmlindexedlineset.getColorPerVertex();
        for(int j = 0; j < i; j++)
        {
            SFVec3f sfvec3f = mfvec3f.getElement(j);
            apoint3d[j] = new Point3d(sfvec3f.getX(), sfvec3f.getY(), sfvec3f.getZ());
        }

        bounds = new BoundingBox(apoint3d[0], apoint3d[0]);
        bounds.combine(apoint3d);
        int k = mfint32.getSize();
        int ai[] = new int[k];
        for(int l = 0; l < k; l++)
            ai[l] = mfint32.getElement(l);

        for(int i1 = 0; i1 < ai.length;)
        {
            int j1 = ai[i1++];
            int k1 = ai[i1++];
            int l1 = j1;
            for(; k1 != -1; k1 = ai[i1++])
            {
                addLine(apoint3d[l1], apoint3d[k1]);
                l1 = k1;
            }

        }

        LineArray linearray = new LineArray(setIndex, 5);
        linearray.setCapability(2);
        linearray.setCapability(17);
        linearray.setCapability(8);
        linearray.setCapability(0);
        Point3d apoint3d1[] = new Point3d[setIndex];
        System.arraycopy(set, 0, apoint3d1, 0, setIndex);
        linearray.setCoordinates(0, apoint3d1);
        VRMLColor vrmlcolor = vrmlindexedlineset.getColor();
        if(vrmlcolor == null)
        {
            noAppearance = true;
            Color3f color3f = getColor3f(vrmlmaterial.getEmissiveColor());
            for(int i2 = 0; i2 < setIndex; i2++)
                linearray.setColor(i2, color3f);

        } else
        {
            MFInt32 mfint32_1 = vrmlindexedlineset.getColorIndex();
            MFColor mfcolor = vrmlcolor.getColor();
            int j2;
            if(mfint32_1 == null)
            {
                j2 = mfint32.getSize();
                flag = true;
            } else
            {
                j2 = mfint32_1.getSize();
            }
            int k2 = 0;
            for(int l2 = 0; l2 < j2; l2++)
            {
                int i3;
                if(flag)
                {
                    i3 = mfint32.getElement(l2);
                    if(i3 == -1)
                    {
                        if(++l2 >= j2)
                            continue;
                        i3 = mfint32.getElement(l2);
                    }
                } else
                {
                    i3 = mfint32_1.getElement(l2);
                    if(i3 == -1)
                    {
                        if(++l2 >= j2)
                            continue;
                        i3 = mfint32_1.getElement(l2);
                    }
                }
                SFColor sfcolor = mfcolor.getElement(i3);
                linearray.setColor(k2++, getColor3f(sfcolor));
                if(!flag1)
                    linearray.setColor(k2++, getColor3f(sfcolor));
            }

        }
        return linearray;
    }

    private Color3f getColor3f(SFColor sfcolor)
    {
        return new Color3f(sfcolor.getRed(), sfcolor.getGreen(), sfcolor.getBlue());
    }

    private Point3d set[];
    private int setIndex;
    private boolean noAppearance;
    String defName;
    BoundingBox bounds;
}
