/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   J3DShape.java

package ncsa.j3d.loaders.vrml97.j3d;

import javax.media.j3d.*;
import javax.vecmath.Point3d;
import ncsa.j3d.loaders.vrml97.*;
import ncsa.j3d.loaders.vrml97.util.ToolkitShape;

// Referenced classes of package ncsa.j3d.loaders.vrml97.j3d:
//            J3DAppearance

public class J3DShape
    implements ToolkitShape
{

    public J3DShape()
    {
        shape3D = null;
        g = null;
        app = null;
        appearance = null;
        geometry = null;
        defName = null;
    }

    public J3DShape(VRMLShape vrmlshape)
    {
        shape3D = null;
        g = null;
        app = null;
        appearance = null;
        geometry = null;
        defName = null;
        produceShape(vrmlshape);
    }

    public BoundingBox getBoundingBox()
    {
        if(g == null)
            return null;
        int i = g.getVertexCount();
        if(i <= 0)
            return null;
        Point3d apoint3d[] = new Point3d[i];
        for(int j = 0; j < i; j++)
            apoint3d[j] = new Point3d();

        g.getCoordinates(0, apoint3d);
        BoundingBox boundingbox = new BoundingBox();
        for(int k = 0; k < i; k++)
            boundingbox.combine(apoint3d[k]);

        return boundingbox;
    }

    public String getDefName()
    {
        return defName;
    }

    public Group getShape()
    {
        Group group = new Group();
        group.setCapability(12);
        group.addChild(shape3D);
        return group;
    }

    public VRMLGeometry getVRMLGeometry()
    {
        return geometry;
    }

    public void produceShape(VRMLShape vrmlshape)
    {
        appearance = vrmlshape.getAppearance();
        if(appearance != null)
        {
            J3DAppearance j3dappearance = new J3DAppearance(appearance);
            if(j3dappearance == null)
                app = new Appearance();
            else
                app = j3dappearance.getAppearance();
        } else
        {
            app = new Appearance();
        }
        app.setCapability(10);
        app.setCapability(11);
        TransparencyAttributes transparencyattributes = app.getTransparencyAttributes();
        if(transparencyattributes == null)
            transparencyattributes = new TransparencyAttributes();
        transparencyattributes.setCapability(2);
        transparencyattributes.setCapability(3);
        app.setTransparencyAttributes(transparencyattributes);
        geometry = vrmlshape.getGeometry();
        defName = vrmlshape.getDefName();
    }

    Shape3D shape3D;
    GeometryArray g;
    Appearance app;
    VRMLAppearance appearance;
    VRMLGeometry geometry;
    String defName;
}
