/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   J3DToolkitImpl.java

package ncsa.j3d.loaders.vrml97.j3d;

import javax.media.j3d.Background;
import javax.media.j3d.DirectionalLight;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import ncsa.j3d.loaders.vrml97.*;
import ncsa.j3d.loaders.vrml97.util.*;

// Referenced classes of package ncsa.j3d.loaders.vrml97.j3d:
//            J3DAnchor, J3DBox, J3DCollision, J3DCone, 
//            J3DCylinder, J3DGroup, J3DIndexedFaceSet, J3DIndexedLineSet, 
//            J3DShape, J3DSphere, J3DText, J3DTransform

public class J3DToolkitImpl extends ToolkitImpl
{

    public J3DToolkitImpl()
    {
    }

    public Color3f getColor3f(SFColor sfcolor)
    {
        return new Color3f(sfcolor.getRed(), sfcolor.getGreen(), sfcolor.getBlue());
    }

    public Point3d getPoint3d(SFVec3f sfvec3f)
    {
        return new Point3d(sfvec3f.getX(), sfvec3f.getY(), sfvec3f.getZ());
    }

    public ToolkitGroup produceAnchor(VRMLAnchor vrmlanchor)
    {
        return new J3DAnchor(vrmlanchor);
    }

    public Background produceBackground(VRMLBackground vrmlbackground)
    {
        return vrmlbackground.getBackground();
    }

    public ToolkitShape produceBox(VRMLShape vrmlshape)
    {
        return new J3DBox(vrmlshape);
    }

    public ToolkitGroup produceChild(ChildNode childnode)
    {
        return null;
    }

    public ToolkitGroup produceCollision(VRMLCollision vrmlcollision)
    {
        return new J3DCollision(vrmlcollision);
    }

    public ToolkitShape produceCone(VRMLShape vrmlshape)
    {
        return new J3DCone(vrmlshape);
    }

    public ToolkitShape produceCylinder(VRMLShape vrmlshape)
    {
        return new J3DCylinder(vrmlshape);
    }

    public DirectionalLight produceDirectionalLight(VRMLDirectionalLight vrmldirectionallight)
    {
        return vrmldirectionallight.getDirectionalLight();
    }

    public ToolkitGroup produceGroup(GroupingNode groupingnode)
    {
        return new J3DGroup(groupingnode);
    }

    public ToolkitShape produceIndexedFaceSet(VRMLShape vrmlshape)
    {
        return new J3DIndexedFaceSet(vrmlshape);
    }

    public ToolkitShape produceIndexedLineSet(VRMLShape vrmlshape)
    {
        return new J3DIndexedLineSet(vrmlshape);
    }

    public ToolkitShape produceShape(VRMLShape vrmlshape)
    {
        return new J3DShape(vrmlshape);
    }

    public ToolkitShape produceSphere(VRMLShape vrmlshape)
    {
        return new J3DSphere(vrmlshape);
    }

    public ToolkitShape produceText(VRMLShape vrmlshape)
    {
        return new J3DText(vrmlshape);
    }

    public ToolkitGroup produceTransformGroup(VRMLTransform vrmltransform)
    {
        J3DTransform j3dtransform = new J3DTransform(vrmltransform);
        return j3dtransform;
    }
}
