/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   J3DTransform.java

package ncsa.j3d.loaders.vrml97.j3d;

import java.io.PrintStream;
import javax.media.j3d.*;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import ncsa.j3d.loaders.vrml97.*;
import ncsa.j3d.loaders.vrml97.util.ToolkitGroup;

// Referenced classes of package ncsa.j3d.loaders.vrml97.j3d:
//            J3DShape, J3DToolkitGroup

public class J3DTransform
    implements ToolkitGroup, J3DToolkitGroup
{

    public J3DTransform()
    {
        group = null;
        transGroup = null;
        debug = false;
    }

    public J3DTransform(VRMLTransform vrmltransform)
    {
        group = null;
        transGroup = null;
        debug = false;
        produceTransform(vrmltransform);
    }

    public Group getGroup()
    {
        if(debug)
            System.out.println("Transform: transGroup = " + transGroup);
        return transGroup;
    }

    public void produceTransform(VRMLTransform vrmltransform)
    {
        MFNode mfnode = vrmltransform.getChildren();
        Object obj = null;
        if(debug)
            System.out.println("transform: kids = " + mfnode);
        if(mfnode == null)
            return;
        group = new Group();
        group.setCapability(12);
        transGroup = new TransformGroup();
        transGroup.setCapability(17);
        transGroup.setCapability(12);
        int i = mfnode.getSize();
        for(int j = 0; j < i; j++)
        {
            ncsa.j3d.loaders.vrml97.VRMLNode vrmlnode = mfnode.getElement(j);
            if(debug)
                System.out.println("transform: node = " + vrmlnode);
            if(vrmlnode instanceof VRMLShape)
            {
                if(debug)
                    System.out.println("transform: VRMLShape");
                VRMLShape vrmlshape = (VRMLShape)vrmlnode;
                J3DShape j3dshape = (J3DShape)vrmlshape.produceShape();
                if(j3dshape != null)
                {
                    Group group1 = j3dshape.getShape();
                    if(group1 != null)
                        group.addChild(group1);
                }
            } else
            if(vrmlnode instanceof GroupingNode)
            {
                GroupingNode groupingnode = (GroupingNode)vrmlnode;
                Group group2 = groupingnode.produceGroup();
                if(group2 != null)
                    group.addChild(group2);
            }
        }

        double d = 1.0D;
        SFVec3f sfvec3f = vrmltransform.getTranslation();
        SFVec3f sfvec3f1 = vrmltransform.getScale();
        Vector3d vector3d = new Vector3d(sfvec3f.x, sfvec3f.y, sfvec3f.z);
        Vector3d vector3d1 = new Vector3d(sfvec3f1.x, sfvec3f1.y, sfvec3f1.z);
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.setIdentity();
        Transform3D transform3d = new Transform3D(matrix3d, new Vector3d(), d);
        TransformGroup transformgroup = new TransformGroup();
        transformgroup.setCapability(12);
        transformgroup.setTransform(transform3d);
        transformgroup.addChild(group);
        Transform3D transform3d1 = new Transform3D();
        transform3d1.setTranslation(vector3d);
        transform3d1.setScale(vector3d1);
        transGroup.setTransform(transform3d1);
        transGroup.addChild(transformgroup);
    }

    Group group;
    TransformGroup transGroup;
    boolean debug;
}
