/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   CELL_TYPES.java

package ncsa.j3d.loaders.vtk;

import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.vtk:
//            CharReader, HEXAHEDRONS, IntReader, LINES, 
//            POLYGONS, TETRAS, TRIANGLE_STRIPS, VERTICES, 
//            VOXELS, VTKLoader

public class CELL_TYPES
{

    public CELL_TYPES()
    {
    }

    public void addShape(int ai[][])
    {
        javax.vecmath.Point3f apoint3f[] = VTKLoader.getPoints();
        int ai1[][] = new int[1][];
        for(int j = 0; j < ai.length; j++)
        {
            ai1[0] = ai[j];
            int i = ai[j].length;
            switch(cellTypes[j])
            {
            default:
                break;

            case 1: // '\001'
            case 2: // '\002'
                VERTICES vertices = new VERTICES();
                vertices.setVertices(ai1[0]);
                vertices.addShape();
                break;

            case 3: // '\003'
                int ai2[][] = new int[i / 2][2];
                int k = 0;
                for(int l = 0; k < i; l++)
                {
                    ai2[l][0] = ai1[0][k];
                    ai2[l][1] = ai1[0][k + 1];
                    k += 2;
                }

                LINES lines = new LINES();
                lines.setLines(ai2);
                lines.addShape();
                break;

            case 4: // '\004'
                LINES lines1 = new LINES();
                lines1.setLines(ai1);
                lines1.addShape();
                break;

            case 5: // '\005'
                int ai3[][] = new int[i / 3][3];
                int i1 = 0;
                for(int j1 = 0; i1 < i; j1++)
                {
                    ai3[j1][0] = ai1[0][i1];
                    ai3[j1][1] = ai1[0][i1 + 1];
                    ai3[j1][2] = ai1[0][i1 + 2];
                    i1 += 3;
                }

                POLYGONS polygons = new POLYGONS();
                polygons.setPolygons(ai3);
                polygons.addShape();
                break;

            case 6: // '\006'
                TRIANGLE_STRIPS triangle_strips = new TRIANGLE_STRIPS();
                triangle_strips.setTriangles(ai1);
                triangle_strips.addShape();
                break;

            case 7: // '\007'
                POLYGONS polygons1 = new POLYGONS();
                polygons1.setPolygons(ai1);
                polygons1.addShape();
                break;

            case 9: // '\t'
                int ai4[][] = new int[i / 4][4];
                int k1 = 0;
                for(int l1 = 0; k1 < i; l1++)
                {
                    ai4[l1][0] = ai1[0][k1];
                    ai4[l1][1] = ai1[0][k1 + 1];
                    ai4[l1][2] = ai1[0][k1 + 2];
                    ai4[l1][3] = ai1[0][k1 + 3];
                    k1 += 4;
                }

                POLYGONS polygons2 = new POLYGONS();
                polygons2.setPolygons(ai4);
                polygons2.addShape();
                break;

            case 8: // '\b'
                int ai5[][] = new int[i / 4][4];
                int i2 = 0;
                for(int j2 = 0; i2 < i; j2++)
                {
                    ai5[j2][0] = ai1[0][i2];
                    ai5[j2][1] = ai1[0][i2 + 1];
                    ai5[j2][2] = ai1[0][i2 + 3];
                    ai5[j2][3] = ai1[0][i2 + 2];
                    i2 += 4;
                }

                POLYGONS polygons3 = new POLYGONS();
                polygons3.setPolygons(ai5);
                polygons3.addShape();
                break;

            case 10: // '\n'
                int ai6[][] = new int[i / 4][4];
                int k2 = 0;
                for(int l2 = 0; k2 < i; l2++)
                {
                    ai6[l2][0] = ai1[0][k2];
                    ai6[l2][1] = ai1[0][k2 + 1];
                    ai6[l2][2] = ai1[0][k2 + 2];
                    ai6[l2][3] = ai1[0][k2 + 3];
                    k2 += 4;
                }

                TETRAS tetras = new TETRAS();
                tetras.setTetras(ai6);
                tetras.addShape();
                break;

            case 12: // '\f'
                int ai7[][] = new int[i / 8][8];
                int i3 = 0;
                for(int j3 = 0; i3 < i; j3++)
                {
                    ai7[j3][0] = ai1[0][i3];
                    ai7[j3][1] = ai1[0][i3 + 1];
                    ai7[j3][2] = ai1[0][i3 + 2];
                    ai7[j3][3] = ai1[0][i3 + 3];
                    ai7[j3][4] = ai1[0][i3 + 4];
                    ai7[j3][5] = ai1[0][i3 + 5];
                    ai7[j3][6] = ai1[0][i3 + 6];
                    ai7[j3][7] = ai1[0][i3 + 7];
                    i3 += 8;
                }

                HEXAHEDRONS hexahedrons = new HEXAHEDRONS();
                hexahedrons.setHexahedrons(ai7);
                hexahedrons.addShape();
                break;

            case 11: // '\013'
                int ai8[][] = new int[i / 8][8];
                int k3 = 0;
                for(int l3 = 0; k3 < i; l3++)
                {
                    ai8[l3][0] = ai1[0][k3];
                    ai8[l3][1] = ai1[0][k3 + 1];
                    ai8[l3][2] = ai1[0][k3 + 2];
                    ai8[l3][3] = ai1[0][k3 + 3];
                    ai8[l3][4] = ai1[0][k3 + 4];
                    ai8[l3][5] = ai1[0][k3 + 5];
                    ai8[l3][6] = ai1[0][k3 + 6];
                    ai8[l3][7] = ai1[0][k3 + 7];
                    k3 += 8;
                }

                VOXELS voxels = new VOXELS();
                voxels.setVoxels(ai8);
                voxels.addShape();
                break;
            }
        }

    }

    public boolean read(ReaderTokenizer readertokenizer, int i)
    {
        IntReader intreader = new IntReader(readertokenizer);
        int j = intreader.read();
        cellTypes = new int[j];
        CharReader charreader = new CharReader(readertokenizer);
        if(i == 1)
            charreader.readBinary();
        for(int k = 0; k < j; k++)
            if(i == 0)
                cellTypes[k] = intreader.read();
            else
                cellTypes[k] = intreader.readBinary();

        return true;
    }

    int cellTypes[];
    static final int VTK_VERTEX = 1;
    static final int VTK_POLY_VERTEX = 2;
    static final int VTK_LINE = 3;
    static final int VTK_POLY_LINE = 4;
    static final int VTK_TRIANGLE = 5;
    static final int VTK_TRIANGLE_STRIP = 6;
    static final int VTK_POLYGON = 7;
    static final int VTK_PIXEL = 8;
    static final int VTK_QUAD = 9;
    static final int VTK_TETRA = 10;
    static final int VTK_VOXEL = 11;
    static final int VTK_HEXAHEDRON = 12;
}
