/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   RECTILINEAR_GRID.java

package ncsa.j3d.loaders.vtk;

import java.io.PrintStream;
import javax.vecmath.Point3f;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.vtk:
//            GRID, CharReader, DataTypeReader, FileReader, 
//            FloatReader, IntReader, LINES, VTKLoader

public class RECTILINEAR_GRID extends GRID
    implements FileReader
{

    public RECTILINEAR_GRID()
    {
        dimX = 0;
        dimY = 0;
        dimZ = 0;
    }

    public void addShape()
    {
        LINES lines = new LINES();
        lines.setLines(connectPoints(dimX, dimY, dimZ));
        lines.addShape();
    }

    public boolean read(ReaderTokenizer readertokenizer, int i)
    {
        IntReader intreader = new IntReader(readertokenizer);
        FloatReader floatreader = new FloatReader(readertokenizer);
        readertokenizer.nextToken();
        if(readertokenizer.sval.equalsIgnoreCase("DIMENSIONS"))
        {
            dimX = intreader.read();
            dimY = intreader.read();
            dimZ = intreader.read();
        } else
        {
            System.out.println("RECTILINEAR_GRID: expecting DIMENSIONS keyword.");
            return false;
        }
        float af[] = new float[dimX];
        float af1[] = new float[dimY];
        float af2[] = new float[dimZ];
        readertokenizer.nextToken();
        String s;
        if(readertokenizer.ttype == -101 && readertokenizer.sval.equalsIgnoreCase("X_COORDINATES"))
        {
            int j = intreader.read();
            readertokenizer.nextToken();
            s = new String(readertokenizer.sval);
        } else
        {
            System.out.println("RECTILINEAR_GRID: expecting X_COORDINATES keyword.");
            return false;
        }
        CharReader charreader = new CharReader(readertokenizer);
        if(i == 1)
            charreader.readBinary();
        if(s.equalsIgnoreCase("bit") && i == 1)
        {
            System.out.println("RECTILINEAR_GRID: cannot read BIT datatype in binary files.");
            return false;
        }
        DataTypeReader datatypereader = new DataTypeReader(readertokenizer, s, i);
        for(int k = 0; k < dimX; k++)
            af[k] = datatypereader.read();

        readertokenizer.nextToken();
        String s1;
        if(readertokenizer.ttype == -101 && readertokenizer.sval.equalsIgnoreCase("Y_COORDINATES"))
        {
            int l = intreader.read();
            readertokenizer.nextToken();
            s1 = new String(readertokenizer.sval);
        } else
        {
            System.out.println("RECTILINEAR_GRID; expecting Y_COORDINATES keyword.");
            return false;
        }
        if(i == 1)
            charreader.readBinary();
        if(s1.equalsIgnoreCase("bit") && i == 1)
        {
            System.out.println("RECTILINEAR_GRID: cannot read BIT datatype in binary files.");
            return false;
        }
        datatypereader = new DataTypeReader(readertokenizer, s1, i);
        for(int i1 = 0; i1 < dimY; i1++)
            af1[i1] = datatypereader.read();

        readertokenizer.nextToken();
        String s2;
        if(readertokenizer.ttype == -101 && readertokenizer.sval.equalsIgnoreCase("Z_COORDINATES"))
        {
            int j1 = intreader.read();
            readertokenizer.nextToken();
            s2 = new String(readertokenizer.sval);
        } else
        {
            System.out.println("RECTILINEAR_GRID; expecting Z_COORDINATES keyword.");
            return false;
        }
        if(i == 1)
            charreader.readBinary();
        if(s2.equalsIgnoreCase("bit") && i == 1)
        {
            System.out.println("RECTILINEAR_GRID: cannot read BIT datatype in binary files.");
            return false;
        }
        datatypereader = new DataTypeReader(readertokenizer, s2, i);
        for(int k1 = 0; k1 < dimZ; k1++)
            af2[k1] = datatypereader.read();

        Point3f apoint3f[] = new Point3f[dimX * dimY * dimZ];
        int l1 = 0;
        for(int i2 = 0; i2 < dimZ; i2++)
        {
            for(int j2 = 0; j2 < dimY; j2++)
            {
                for(int k2 = 0; k2 < dimX; k2++)
                {
                    apoint3f[l1] = new Point3f(af[k2], af1[j2], af2[i2]);
                    l1++;
                }

            }

        }

        VTKLoader.setPoints(apoint3f);
        return true;
    }

    int dimX;
    int dimY;
    int dimZ;
}
