/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   STRUCTURED_POINTS.java

package ncsa.j3d.loaders.vtk;

import java.io.PrintStream;
import javax.vecmath.Point3f;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.vtk:
//            GRID, FileReader, FloatReader, IntReader, 
//            LINES, VTKLoader

public class STRUCTURED_POINTS extends GRID
    implements FileReader
{

    public STRUCTURED_POINTS()
    {
        dimX = 0;
        dimY = 0;
        dimZ = 0;
    }

    public void addShape()
    {
        LINES lines = new LINES();
        lines.setLines(connectPoints(dimX, dimY, dimZ));
        lines.addShape();
    }

    public boolean read(ReaderTokenizer readertokenizer, int i)
    {
        float f = 0.0F;
        float f1 = 0.0F;
        float f2 = 0.0F;
        float f3 = 0.0F;
        float f4 = 0.0F;
        float f5 = 0.0F;
        IntReader intreader = new IntReader(readertokenizer);
        FloatReader floatreader = new FloatReader(readertokenizer);
        int j = 3;
        boolean flag = true;
        while(j > 0) 
        {
            boolean flag1 = false;
            readertokenizer.nextToken();
            if(readertokenizer.ttype == -101 && readertokenizer.sval.equalsIgnoreCase("DIMENSIONS"))
            {
                dimX = intreader.read();
                dimY = intreader.read();
                dimZ = intreader.read();
                flag1 = true;
                j--;
            }
            if(readertokenizer.ttype == -101 && readertokenizer.sval.equalsIgnoreCase("ORIGIN"))
            {
                f = floatreader.read();
                f1 = floatreader.read();
                f2 = floatreader.read();
                flag1 = true;
                j--;
            }
            if(readertokenizer.ttype == -101 && (readertokenizer.sval.equalsIgnoreCase("SPACING") || readertokenizer.sval.equalsIgnoreCase("ASPECT_RATIO")))
            {
                f3 = floatreader.read();
                f4 = floatreader.read();
                f5 = floatreader.read();
                flag1 = true;
                j--;
            }
            if(!flag1)
            {
                System.out.println("STRUCTURED_POINTS: expecting DIMENSIONS, ORIGIN, SPACING, or ASPECT_RATIO.");
                return false;
            }
        }
        Point3f apoint3f[] = new Point3f[dimX * dimY * dimZ];
        int k = 0;
        for(int l = 0; l < dimZ; l++)
        {
            for(int i1 = 0; i1 < dimY; i1++)
            {
                for(int j1 = 0; j1 < dimX; j1++)
                {
                    apoint3f[k] = new Point3f((float)j1 * f3 + f, (float)i1 * f4 + f1, (float)l * f5 + f2);
                    k++;
                }

            }

        }

        VTKLoader.setPoints(apoint3f);
        return true;
    }

    int dimX;
    int dimY;
    int dimZ;
}
