/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   VTKLoader.java

package ncsa.j3d.loaders.vtk;

import java.io.*;
import java.util.Vector;
import javax.media.j3d.*;
import javax.vecmath.*;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.vtk:
//            FileReader, POINTS

public class VTKLoader
{

    public VTKLoader()
    {
        filetype = 0;
    }

    void PrintError(String s)
    {
        System.out.println("File error, line #" + reader.lineno() + ": " + s);
    }

    public static void addNode(Node node)
    {
        bg.addChild(node);
    }

    public static Appearance getAppearance()
    {
        return appearance;
    }

    public static Color4f[] getColors()
    {
        return colors;
    }

    public static Vector3f[] getNormals()
    {
        return normals;
    }

    public static String getPckg()
    {
        return pckg;
    }

    public static int getPointCount()
    {
        return pointCount;
    }

    public static Point3f[] getPoints()
    {
        return points.getPoints();
    }

    public BranchGroup load(Reader reader1, int i)
        throws IOException
    {
        endian = i;
        bg = new BranchGroup();
        bg.setCapability(3);
        TransformGroup transformgroup = new TransformGroup();
        bg.addChild(transformgroup);
        points = new POINTS();
        pointCount = 0;
        normals = null;
        colors = null;
        Material material = new Material();
        material.setDiffuseColor(0.3F, 0.3F, 0.3F);
        material.setAmbientColor(0.7F, 0.7F, 0.7F);
        appearance = new Appearance();
        appearance.setMaterial(material);
        BufferedReader bufferedreader = new BufferedReader(reader1);
        String s = bufferedreader.readLine();
        if(!s.substring(0, 14).equalsIgnoreCase("# vtk DataFile"))
        {
            System.out.println("Incorrect VTK data file header.");
            return new BranchGroup();
        }
        if(!s.equalsIgnoreCase("# vtk DataFile Version 2.0") && !s.equalsIgnoreCase("# vtk DataFile Version 1.0") && debug)
        {
            System.out.println("Untested VTK file version (not 1.0 or 2.0).");
            System.out.println("Processing will continue.");
        }
        String s1 = bufferedreader.readLine();
        if(debug)
        {
            System.out.println("");
            System.out.println("READING A NEW VTK FILE");
            System.out.println("File comment: " + s1);
            System.out.println(s);
        }
        reader = new ReaderTokenizer(bufferedreader);
        reader.nextToken();
        String s2 = reader.sval;
        if(s2.equalsIgnoreCase("ASCII"))
            filetype = 0;
        else
        if(s2.equalsIgnoreCase("BINARY"))
        {
            filetype = 1;
        } else
        {
            PrintError("Expected keywords BINARY or ASCII not found.");
            return new BranchGroup();
        }
        Object obj = null;
        String s4 = null;
        Vector vector = new Vector();
        reader.nextToken();
        while(reader.ttype != -103) 
            try
            {
                if(reader.ttype != -101)
                {
                    PrintError("Expecting a keyword string.");
                    return new BranchGroup();
                }
                s4 = reader.sval;
                if(!s4.equalsIgnoreCase("DATASET"))
                {
                    if(debug)
                        System.out.println("VTKLoader: reading " + s4);
                    String s3 = new String(pckg + "." + s4);
                    vector.add((ncsa.j3d.loaders.vtk.FileReader)Class.forName(s3).newInstance());
                    if(!((ncsa.j3d.loaders.vtk.FileReader)vector.lastElement()).read(reader, filetype))
                        return new BranchGroup();
                }
                reader.nextToken();
            }
            catch(Exception exception)
            {
                PrintError("Error in type: " + s4);
                System.out.println("   (" + exception + ")");
                return new BranchGroup();
            }
        for(int j = 0; j < vector.size(); j++)
        {
            String s5 = vector.elementAt(j).getClass().getName();
            String s6 = s5.substring(pckg.length() + 1);
            if(debug && !s6.equalsIgnoreCase("POINT_DATA"))
                System.out.println("VTKLoader: adding " + s6);
            ((ncsa.j3d.loaders.vtk.FileReader)vector.elementAt(j)).addShape();
        }

        if(debug)
            System.out.println("VTKLoader: Done.");
        return bg;
    }

    public static void main(String args[])
    {
        try
        {
            java.io.FileReader filereader = new java.io.FileReader(args[0]);  // Modified from the decompiled source by Sean Luke, George Mason University
            VTKLoader vtkloader = new VTKLoader();
            BranchGroup branchgroup = vtkloader.load(filereader, 1);
        }
        catch(Exception exception)
        {
            System.out.println(exception);
        }
    }

    public static void setColors(Color4f acolor4f[])
    {
        colors = acolor4f;
    }

    public static void setNormals(Vector3f avector3f[])
    {
        normals = avector3f;
    }

    public static void setPointCount(int i)
    {
        pointCount = i;
    }

    public static void setPoints(Point3f apoint3f[])
    {
        points.setPoints(apoint3f);
        pointCount = apoint3f.length;
    }

    public static final int ASCII = 0;
    public static final int BINARY = 1;
    public static final int BIG = 0;
    public static final int LITTLE = 1;
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    public static boolean debug = false;
    int filetype;
    public static int endian = 1;
    private static BranchGroup bg;
    private ReaderTokenizer reader;
    static String pckg = "ncsa.j3d.loaders.vtk";
    static POINTS points = new POINTS();
    static int pointCount = 0;
    static Vector3f normals[] = null;
    static Color4f colors[] = null;
    static Appearance appearance;

}
