/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   AppearanceReader.java

package ncsa.j3d.loaders.wavefront;

import java.io.*;
import java.net.URL;
import javax.media.j3d.*;
import javax.vecmath.Color3f;

// Referenced classes of package ncsa.j3d.loaders.wavefront:
//            ObjectReader, AppearanceManager

public class AppearanceReader extends ObjectReader
{

    public AppearanceReader(String s)
        throws FileNotFoundException
    {
        super(new BufferedReader(new FileReader(figureMaterialFilename(s))));
        am = new AppearanceManager();
        filename = figureMaterialFilename(s);
    }

    public AppearanceReader(URL url)
        throws FileNotFoundException
    {
        am = new AppearanceManager();
        try
        {
            init(new BufferedReader(new InputStreamReader(url.openStream())));
        }
        catch(Exception _ex)
        {
            System.out.println("Couldn't open stream to " + url);
            throw new FileNotFoundException();
        }
    }

    public Group consume()
    {
        return null;
    }

    public AppearanceManager create()
    {
        try
        {
            while(!eof()) 
            {
                String s = getWord();
                if(s != null)
                    if(s.equals("newmtl"))
                        handleNewMaterial();
                    else
                    if(s.equals("Ka"))
                        handleKa();
                    else
                    if(s.equals("Kd"))
                        handleKd();
                    else
                    if(s.equals("Ks"))
                        handleKs();
                    else
                    if(s.equals("illum"))
                        handleIllum();
                    else
                    if(s.equals("Ns"))
                        handleNs();
            }
        }
        catch(IOException ioexception)
        {
            System.out.println("AppearanceReader! -> ");
            System.out.println(ioexception);
        }
        forceOldMaterial();
        return am;
    }

    static String figureMaterialFilename(String s)
    {
        if(s.endsWith(".mtl"))
            return new String(s);
        String s1;
        if(s.endsWith(".obj"))
        {
            s1 = s.substring(0, s.indexOf(".obj"));
            s1 = s1 + ".mtl";
        } else
        {
            s1 = new String(s);
        }
        return s1;
    }

    void forceOldMaterial()
    {
        if(a != null && m != null)
        {
            a.setMaterial(m);
            am.add(name, a);
        }
        a = new Appearance();
        m = new Material();
        m.setShininess(128F);
        m.setLightingEnable(true);
    }

    void handleIllum()
        throws IOException
    {
        String s = getLine();
    }

    void handleKa()
        throws IOException
    {
        Color3f color3f = new Color3f((float)getDouble(), (float)getDouble(), (float)getDouble());
        m.setAmbientColor(color3f);
    }

    void handleKd()
        throws IOException
    {
        Color3f color3f = new Color3f((float)getDouble(), (float)getDouble(), (float)getDouble());
        m.setDiffuseColor(color3f);
    }

    void handleKs()
        throws IOException
    {
        Color3f color3f = new Color3f((float)getDouble(), (float)getDouble(), (float)getDouble());
        m.setSpecularColor(color3f);
    }

    void handleNewMaterial()
        throws IOException
    {
        forceOldMaterial();
        name = getWord();
    }

    void handleNs()
        throws IOException
    {
        String s = getLine();
    }

    AppearanceManager am;
    String filename;
    DataInputStream dis;
    String name;
    Appearance a;
    Material m;
}
