/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   FaceManager.java

package ncsa.j3d.loaders.wavefront;

import com.sun.j3d.utils.geometry.*;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.*;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

// Referenced classes of package ncsa.j3d.loaders.wavefront:
//            Face, VertexManager, VertexNormalManager

public class FaceManager extends Vector
{

    public FaceManager(VertexManager vertexmanager, VertexNormalManager vertexnormalmanager, Appearance appearance)
    {
        triangulator = new Triangulator();
        vm = vertexmanager;
        vnm = vertexnormalmanager;
        a = appearance;
        if(appearance == null)
            appearance = new Appearance();
    }

    public void addFace(Face face)
    {
        addElement(face);
    }

    public void changeAppearance(Appearance appearance)
    {
        a = appearance;
    }

    public Node getShape()
    {
        info = new GeometryInfo(5);
        info.setCoordinates(vm.getArray());
        int ai[] = new int[size()];
        int i = 0;
        int j = 0;
        for(Enumeration enumeration = elements(); enumeration.hasMoreElements();)
        {
            Face face = (Face)enumeration.nextElement();
            ai[i] = face.getVertexSize();
            j += ai[i];
            i++;
        }

        int ai1[] = new int[j];
        int k = 0;
        for(Enumeration enumeration1 = elements(); enumeration1.hasMoreElements();)
        {
            Face face1 = (Face)enumeration1.nextElement();
            int ai2[] = face1.getFace();
            for(int l = 0; l < face1.getVertexSize(); l++)
                ai1[k++] = ai2[l];

        }

        info.setCoordinateIndices(ai1);
        info.setStripCounts(ai);
        triangulator.triangulate(info);
        NormalGenerator normalgenerator = new NormalGenerator();
        normalgenerator.generateNormals(info);
        javax.media.j3d.GeometryArray geometryarray = info.getGeometryArray();
        return new Shape3D(geometryarray, a);
    }

    VertexManager vm;
    VertexNormalManager vnm;
    Triangulator triangulator;
    GeometryInfo info;
    Group group;
    Point3d points[];
    Vector3f normals[];
    Appearance a;
}
