/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   GenReader.java

package ncsa.j3d.loaders.wavefront;

import com.sun.j3d.loaders.Scene;
import java.io.*;
import javax.vecmath.*;
import ncsa.util.ReaderTokenizer;

public class GenReader extends ReaderTokenizer
{

    public GenReader(Reader reader)
        throws Exception
    {
        super(reader);
        groupname = new String("default");
        wordChars(47, 47);
        newlineChar(10);
        newlineChar(13);
    }

    protected void addedProcessing()
    {
        clearLine();
    }

    void clearLine()
    {
        while(!eol() && nextToken() != -103) ;
    }

    public Scene consume()
    {
        try
        {
            while(nextToken() != -103) 
                if(super.ttype == -101)
                    process();
        }
        catch(NumberFormatException numberformatexception)
        {
            System.out.println(String.valueOf(numberformatexception) + " on line " + super.lineno);
            return null;
        }
        return null;
    }

    protected void face(int i)
    {
        System.out.print(i + " ");
    }

    protected void faceEnd()
    {
        System.out.println(" ");
    }

    protected void faceStart()
    {
        System.out.print("f ");
    }

    protected void group(String s)
    {
        System.out.print(s + " ");
    }

    protected void groupEnd()
    {
        System.out.println(" ");
    }

    protected void groupStart()
    {
        System.out.print("g ");
    }

    void handleFace()
        throws NumberFormatException
    {
        faceStart();
        while(!eol() && nextToken() != -103) 
            if(super.ttype == -102)
            {
                face((int)super.nval);
                processExtendedFace();
            }
        faceEnd();
    }

    void handleGroup()
    {
        groupStart();
        while(!eol() && nextToken() != -103) 
            if(super.ttype == -101)
                group(super.sval);
        groupEnd();
    }

    void handleLine()
        throws NumberFormatException
    {
        clearLine();
    }

    void handleMaplib()
    {
        clearLine();
    }

    void handleMtllib()
    {
        clearLine();
    }

    void handleShadow_obj()
    {
        clearLine();
    }

    void handleSmoothingGroup()
    {
        clearLine();
    }

    void handleUsemap()
    {
        clearLine();
    }

    void handleUsemtl()
    {
        if(!eol() && nextToken() == -101)
            material(super.sval);
    }

    void handleVertex()
    {
        vertex(readPoint());
    }

    void handleVertexNormal()
    {
        vertexNormal(readVector());
    }

    void handleVertexTexture()
    {
        clearLine();
    }

    public static void main(String args[])
    {
        if(args.length != 1)
        {
            System.out.println("usage: java ncsa.j3d.loaders.wavefront.GenLoader filename");
            return;
        }
        try
        {
            GenReader genreader = new GenReader(new FileReader(args[0]));
            genreader.consume();
        }
        catch(Exception exception)
        {
            System.out.println("WavefrontReader.main");
            System.out.println(exception);
        }
    }

    protected void material(String s)
    {
        System.out.println("usemtl " + s);
    }

    protected void process()
    {
        if(super.sval.equals("v"))
            handleVertex();
        else
        if(super.sval.equals("vn"))
            handleVertexNormal();
        else
        if(super.sval.equals("f") || super.sval.equals("fo"))
            handleFace();
        else
        if(super.sval.equals("l"))
            handleLine();
        else
        if(super.sval.equals("usemtl"))
            handleUsemtl();
        else
        if(super.sval.equals("g"))
            handleGroup();
        else
        if(super.sval.equals("s"))
            handleSmoothingGroup();
        else
        if(super.sval.equals("vt"))
            handleVertexTexture();
        else
        if(super.sval.equals("usemap"))
            handleUsemap();
        else
        if(super.sval.equals("mtllib"))
            handleMtllib();
        else
        if(super.sval.equals("maplib"))
            handleMaplib();
        else
        if(super.sval.equals("shadow_obj"))
            handleShadow_obj();
        else
            addedProcessing();
    }

    protected void processExtendedFace()
    {
        if(eol())
            return;
        if(nextToken() != -101)
            pushBack();
    }

    protected Point3d readPoint()
    {
        Point3d point3d = new Point3d();
        if(nextToken() == -102)
            point3d.x = super.nval;
        else
            return null;
        if(nextToken() == -102)
            point3d.y = super.nval;
        else
            return null;
        if(nextToken() == -102)
            point3d.z = super.nval;
        else
            return null;
        return point3d;
    }

    protected Vector3d readVector()
    {
        Vector3d vector3d = new Vector3d();
        if(nextToken() == -102)
            vector3d.x = super.nval;
        else
            return null;
        if(nextToken() == -102)
            vector3d.y = super.nval;
        else
            return null;
        if(nextToken() == -102)
            vector3d.z = super.nval;
        else
            return null;
        return vector3d;
    }

    protected void vertex(Point3d point3d)
    {
        if(point3d != null)
            System.out.println("v " + ((Tuple3d) (point3d)).x + " " + ((Tuple3d) (point3d)).y + " " + ((Tuple3d) (point3d)).z);
        else
            System.out.println("v ERROR: could not read the point");
    }

    protected void vertexNormal(Vector3d vector3d)
    {
        if(vector3d != null)
            System.out.println("vn " + ((Tuple3d) (vector3d)).x + " " + ((Tuple3d) (vector3d)).y + " " + ((Tuple3d) (vector3d)).z);
        else
            System.out.println("v Error: could not read the normal");
    }

    String groupname;
}
