/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ObjectReader.java

package ncsa.j3d.loaders.wavefront;

import java.io.*;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Group;
import javax.vecmath.Point3d;

public abstract class ObjectReader
{

    public ObjectReader()
    {
        st = null;
    }

    public ObjectReader(Reader reader)
    {
        st = null;
        init(reader);
    }

    private boolean advance()
    {
        try
        {
            st.nextToken();
        }
        catch(Exception exception)
        {
            System.out.println(exception);
            return false;
        }
        return true;
    }

    public abstract Group consume();

    public boolean eof()
    {
        return st.ttype == -1;
    }

    public boolean eol()
    {
        return st.ttype == 10;
    }

    public double getDouble()
        throws NumberFormatException
    {
        if(!advance())
            throw new NumberFormatException("expected double value");
        if(eol() && !advance())
            throw new NumberFormatException("expected double value");
        if(st.ttype != -2)
            throw new NumberFormatException("expected double value");
        else
            return st.nval;
    }

    public int[] getIntArray()
        throws NumberFormatException
    {
        Vector vector = new Vector();
        while(!eol()) 
        {
            if((!advance() || st.ttype != -2) && !eol())
                throw new NumberFormatException("expected double value");
            if(!eol())
                vector.addElement(new Integer((int)st.nval));
        }
        int ai[] = new int[vector.size()];
        int i = 0;
        for(Enumeration enumeration = vector.elements(); enumeration.hasMoreElements();)
        {
            ai[i] = ((Integer)enumeration.nextElement()).intValue();
            i++;
        }

        return ai;
    }

    public String getLine()
    {
        String s = new String();
        while(!eol()) 
        {
            if(!advance())
                return s;
            if(!eol())
                if(st.ttype == -3)
                    s = s + st.sval + " ";
                else
                    s = s + st.nval + " ";
        }
        return s;
    }

    public String getWord()
    {
        if(!advance())
            return null;
        if(st.ttype != -3 && !eol())
            return null;
        else
            return eol() ? null : new String(st.sval);
    }

    public void init(Reader reader)
    {
        st = new StreamTokenizer(reader);
        st.resetSyntax();
        st.wordChars(0, 255);
        st.whitespaceChars(0, 32);
        st.eolIsSignificant(true);
        st.commentChar(35);
        st.parseNumbers();
    }

    public Point3d readPoint3d()
    {
        if(!advance())
            return null;
        if(eol() && !advance())
            return null;
        if(st.ttype != -2)
        {
            System.out.println("readPoint1 syntax error on line " + st.lineno());
            return null;
        }
        double d = st.nval;
        if(!advance())
            return null;
        if(st.ttype != -2)
        {
            System.out.println("readPoint2 syntax error on line " + st.lineno());
            return null;
        }
        double d1 = st.nval;
        if(!advance())
            return null;
        if(st.ttype != -2)
        {
            System.out.println("readPoint3 syntax error on line " + st.lineno());
            return null;
        } else
        {
            double d2 = st.nval;
            return new Point3d(d, d1, d2);
        }
    }

    StreamTokenizer st;
}
