/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   WavefrontReader.java

package ncsa.j3d.loaders.wavefront;

import com.sun.j3d.loaders.Scene;
import java.io.*;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Group;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.wavefront:
//            GenReader, AppearanceManager, AppearanceReader, Face, 
//            SceneManager, VertexManager, VertexNormalManager

public class WavefrontReader extends GenReader
{

    public WavefrontReader(Reader reader, String s, String s1)
        throws Exception
    {
        super(reader);
        vm = new VertexManager();
        vnm = new VertexNormalManager();
        groupname = new String("default");
        basePath = null;
        baseUrl = null;
        basePath = s;
        baseUrl = s1;
        am = new AppearanceManager();
        groupman = new SceneManager(vm, vnm, am);
    }

    public Scene consume()
    {
        Scene scene = super.consume();
        Scene scene1 = groupman.getScene();
        vm = null;
        vnm = null;
        groupman = null;
        am = null;
        return scene1;
    }

    AppearanceManager createAppearanceManager(String s)
    {
        try
        {
            AppearanceReader appearancereader = null;
            if(basePath != null)
            {
                appearancereader = new AppearanceReader(basePath + s);
            } else
            {
                AppearanceReader appearancereader1;
                try
                {
                    appearancereader1 = new AppearanceReader(new URL(baseUrl + s));
                }
                catch(Exception _ex)
                {
                    am = new AppearanceManager();
                    return am;
                }
                am = appearancereader1.create();
            }
        }
        catch(FileNotFoundException _ex)
        {
            try
            {
                AppearanceReader appearancereader2 = null;
                appearancereader2 = new AppearanceReader(s);
                am = appearancereader2.create();
            }
            catch(FileNotFoundException _ex2)
            {
                System.out.println("Material file not found");
                am = new AppearanceManager();
            }
        }
        return am;
    }

    protected void face(int i)
    {
        v.addElement(new Integer(i - 1));
    }

    protected void faceEnd()
    {
        int ai[] = new int[v.size()];
        int i = 0;
        for(Enumeration enumeration = v.elements(); enumeration.hasMoreElements();)
            ai[i++] = ((Integer)enumeration.nextElement()).intValue();

        groupman.addFace(new Face(ai, null), groupname);
    }

    protected void faceStart()
    {
        v = new Vector();
    }

    protected void group(String s)
    {
        if(s.equals("default") || s.equals("shape") || s.equals("all") || s.equals("link") || s.equals("copy"))
        {
            return;
        } else
        {
            groupname = s;
            return;
        }
    }

    protected void groupEnd()
    {
    }

    protected void groupStart()
    {
        groupname = new String("default");
    }

    void handleMtllib()
    {
        int i = charType(46);
        int j = charType(47);
        int k = charType(92);
        wordChars(46, 46);
        wordChars(47, 47);
        wordChars(92, 92);
        if(nextToken() == -101)
        {
            AppearanceManager appearancemanager = createAppearanceManager(super.sval);
            groupman.setAppearanceManager(appearancemanager);
        }
        setType(46, i);
        setType(47, j);
        setType(92, k);
    }

    protected void material(String s)
    {
        am.use(s);
    }

    public void setAppearanceToGroupName()
    {
        groupman.setAppearanceToGroupName();
    }

    protected void vertex(Point3d point3d)
    {
        if(point3d != null)
            vm.add(point3d);
    }

    protected void vertexNormal(Vector3d vector3d)
    {
        if(vector3d != null)
            vnm.add(new Point3d(vector3d));
    }

    VertexManager vm;
    VertexNormalManager vnm;
    SceneManager groupman;
    AppearanceManager am;
    Group group;
    String groupname;
    String basePath;
    String baseUrl;
    Vector v;
}
