/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   PortfolioProperties.java

package ncsa.j3d.ui;

import java.io.*;
import java.util.*;

public class PortfolioProperties extends Properties
{

    protected PortfolioProperties()
    {
        try
        {
            load(new FileInputStream("portfolio.properties"));
        }
        catch(FileNotFoundException _ex)
        {
            if(!printedError)
            {
                System.out.println("No portfolio.properties file");
                printedError = true;
            }
            makeDefault(this);
        }
        catch(IOException ioexception)
        {
            System.out.println(ioexception);
        }
    }

    public Enumeration getEnumeration(String s)
    {
        Vector vector = getVector(s);
        return vector.elements();
    }

    public Object getObject(String s)
    {
        String s1 = getProperty(s);
        if(s1 == null)
            return null;
        try
        {
            return Class.forName(s1).newInstance();
        }
        catch(ClassNotFoundException _ex)
        {
            System.out.println(s + " not found.");
        }
        catch(IllegalAccessException illegalaccessexception)
        {
            System.out.println(illegalaccessexception);
        }
        catch(InstantiationException instantiationexception)
        {
            System.out.println(instantiationexception);
        }
        return null;
    }

    public Object[] getObjects(String s)
    {
        Vector vector = getVector(s);
        Object aobj[] = new Object[vector.size()];
        for(int i = 0; i < aobj.length; i++)
            aobj[i] = vector.elementAt(i);

        return aobj;
    }

    public Vector getVector(String s)
    {
        Vector vector = new Vector();
        int i = 0;
        String s1;
        while((s1 = getProperty(s + i++)) != null) 
            try
            {
                vector.addElement(Class.forName(s1).newInstance());
            }
            catch(ClassNotFoundException _ex)
            {
                System.out.println("PortfolioProperties could not find " + s1);
            }
            catch(IllegalAccessException illegalaccessexception)
            {
                System.out.println(illegalaccessexception);
            }
            catch(InstantiationException instantiationexception)
            {
                System.out.println(instantiationexception);
            }
        return vector;
    }

    public static PortfolioProperties instance()
    {
        if(instance == null)
            instance = new PortfolioProperties();
        return instance;
    }

    public static void main(String args[])
    {
        PortfolioProperties portfolioproperties = new PortfolioProperties();
        makeDefault(portfolioproperties);
        save(portfolioproperties);
    }

    public static void makeDefault(Properties properties)
    {
        properties.put("InputSource0", "ncsa.j3d.ui.events.KeyPress");
        properties.put("InputSource1", "ncsa.j3d.ui.events.KeyRelease");
        properties.put("InputSource2", "ncsa.j3d.ui.events.MouseDown");
        properties.put("InputSource3", "ncsa.j3d.ui.events.MouseUp");
        properties.put("InputSource4", "ncsa.j3d.ui.events.MouseDrag");
        properties.put("ActiveTool", "ncsa.j3d.ui.tools.PickTool");
        properties.put("InactiveTool0", "ncsa.j3d.ui.tools.ViewTool");
    }

    public static void reload()
    {
        instance = null;
    }

    public static void save(Properties properties)
    {
        try
        {
            properties.store(new FileOutputStream("portfolio.properties"), "NCSA Portfolio configuration file");
        }
        catch(IOException ioexception)
        {
            System.out.println(ioexception);
        }
    }

    protected static boolean printedError = false;
    protected static PortfolioProperties instance = null;

}
