/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   EventManager.java

package ncsa.j3d.ui.events;

import java.io.PrintStream;
import java.util.*;
import javax.media.j3d.*;
import ncsa.devices.NCSAInputDevice;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.tools.ToolManager;

// Referenced classes of package ncsa.j3d.ui.events:
//            PortfolioEvent, PortfolioEventReceiver

public class EventManager
    implements PortfolioEventReceiver
{

    protected EventManager()
    {
        behaviors = new Vector();
        eventSources = new Vector();
        eventReceivers = new Vector();
        connect = false;
        eventGroup = new BranchGroup();
        eventGroup.setCapability(17);
    }

    public void addBehavior(Behavior behavior)
    {
        disconnect();
        insertBehavior(behavior);
        connect();
    }

    public void addEvent(PortfolioEvent portfolioevent)
    {
        if(portfolioevent instanceof Behavior)
            addBehavior((Behavior)portfolioevent);
        else
            addEventSource(portfolioevent);
    }

    public void addEventReceiver(PortfolioEventReceiver portfolioeventreceiver)
    {
        eventReceivers.addElement(portfolioeventreceiver);
    }

    public void addEventSource(Object obj)
    {
        eventSources.addElement(obj);
    }

    protected void configurePortfolioDevices(InputDevice inputdevice, int i)
    {
        PortfolioProperties portfolioproperties = PortfolioProperties.instance();
        String s = portfolioproperties.getProperty("InputDevice" + i + ".Name");
        if(!(inputdevice instanceof NCSAInputDevice) && s != null)
        {
            System.out.println("Cannot set name for device " + i + " because it does not implement ncsa.devices.NCSAInputDevice.");
            return;
        }
        if(inputdevice instanceof NCSAInputDevice)
        {
            NCSAInputDevice ncsainputdevice = (NCSAInputDevice)inputdevice;
            ncsainputdevice.initializePortfolioDevice(s);
        }
    }

    protected void connect()
    {
        if(branchGroup != null)
        {
            branchGroup.addChild(eventGroup);
            connect = true;
        }
    }

    protected void disconnect()
    {
        if(connect)
            eventGroup.detach();
        connect = false;
    }

    protected void insertBehavior(Behavior behavior)
    {
        eventGroup.addChild(behavior);
        behaviors.addElement(behavior);
    }

    public static EventManager instance()
    {
        if(instance == null)
            instance = new EventManager();
        return instance;
    }

    public void loadInputDevices()
    {
        Object aobj[] = PortfolioProperties.instance().getObjects("InputDevice");
        PhysicalEnvironment physicalenvironment = null;
        if(aobj.length > 0)
        {
            Canvas3D canvas3d = ToolManager.instance().getCanvas();
            physicalenvironment = canvas3d.getView().getPhysicalEnvironment();
        }
        for(int i = 0; i < aobj.length; i++)
        {
            InputDevice inputdevice = (InputDevice)aobj[i];
            inputdevice.initialize();
            configurePortfolioDevices(inputdevice, i);
            setSensors(physicalenvironment, inputdevice, i);
            physicalenvironment.addInputDevice(inputdevice);
        }

    }

    public void loadInputSources()
    {
        Object aobj[] = PortfolioProperties.instance().getObjects("InputSource");
        for(int i = 0; i < aobj.length; i++)
        {
            PortfolioEvent portfolioevent = (PortfolioEvent)aobj[i];
            portfolioevent.setReceiver(this);
            addEvent(portfolioevent);
        }

    }

    public boolean notify(EventObject eventobject)
    {
        for(Enumeration enumeration = eventReceivers.elements(); enumeration.hasMoreElements(); ((PortfolioEventReceiver)enumeration.nextElement()).notify(eventobject));
        return true;
    }

    public void removeBehavior(Behavior behavior)
    {
        System.out.println("EventManager.removeBehavior needs to be implemented");
    }

    public void setBranchGroup(BranchGroup branchgroup)
    {
        if(branchGroup == null)
        {
            branchGroup = branchgroup;
            connect();
        }
    }

    public void setHeadIndex()
    {
        String s = PortfolioProperties.instance().getProperty("HeadIndex");
        if(s != null)
        {
            ToolManager.instance().getCanvas().getView().getPhysicalEnvironment().setHeadIndex(Integer.parseInt(s));
            ToolManager.instance().getCanvas().getView().setTrackingEnable(true);
            ToolManager.instance().getCanvas().getView().setUserHeadToVworldEnable(true);
            System.out.println(ToolManager.instance().getCanvas().getView().getPhysicalEnvironment().getSensor(Integer.parseInt(s)));
        }
    }

    protected void setSensors(PhysicalEnvironment physicalenvironment, InputDevice inputdevice, int i)
    {
        int j = 0;
        String s;
        while((s = PortfolioProperties.instance().getProperty("InputDevice" + i + ".Channel" + j)) != null) 
        {
            if(inputdevice.getSensorCount() <= j)
            {
                System.out.println("InputDevice" + i + " can only support " + inputdevice.getSensorCount() + " Channel(s).");
                System.out.println("All subsequent channel definitions have been ignored.");
                return;
            }
            physicalenvironment.setSensor(Integer.parseInt(s), inputdevice.getSensor(j++));
        }
    }

    Vector behaviors;
    Vector eventSources;
    Vector eventReceivers;
    BranchGroup branchGroup;
    BranchGroup eventGroup;
    boolean connect;
    private static EventManager instance = null;

}
