/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   RecordableCanvas3D.java

package ncsa.j3d.ui.record;

import com.sun.image.codec.jpeg.*;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.io.*;
import java.util.Properties;
import java.util.Vector;
import javax.media.j3d.*;
import javax.vecmath.Point3f;
import ncsa.j3d.ui.PortfolioProperties;

// Referenced classes of package ncsa.j3d.ui.record:
//            RendezvousInterface

public class RecordableCanvas3D extends Canvas3D
    implements RendezvousInterface
{

    public RecordableCanvas3D(GraphicsConfiguration graphicsconfiguration)
    {
        super(graphicsconfiguration);
        images = new Vector();
        frame = 0;
        height = 0;
        width = 0;
        recording = false;
        captureInPostRender = false;
        bRepaint = true;
        takeSnapShot = false;
        prefix = "image";
        dir = "frames";
        file_separator = null;
        filename = "image.jpg";
        gc = getGraphicsContext3D();
        Properties properties = System.getProperties();
        file_separator = properties.getProperty("file.separator");
        PortfolioProperties portfolioproperties = PortfolioProperties.instance();
        String s = portfolioproperties.getProperty("RecordableCanvas3D.repaint");
        if(s == null)
            return;
        if(s.equals("true"))
            bRepaint = true;
        else
        if(s.equals("false"))
            bRepaint = false;
    }

    public RecordableCanvas3D(GraphicsConfiguration graphicsconfiguration, boolean flag)
    {
        this(graphicsconfiguration);
        bRepaint = flag;
    }

    public synchronized void Notify()
    {
        notify();
    }

    public void allocImage()
    {
        if(image != null && raster != null && width == getWidth() && height == getHeight())
        {
            return;
        } else
        {
            image = new BufferedImage(getWidth(), getHeight(), 2);
            ImageComponent2D imagecomponent2d = new ImageComponent2D(1, image);
            raster = new Raster(new Point3f(0.0F, 0.0F, 0.0F), 1, 0, 0, image.getWidth(), image.getHeight(), imagecomponent2d, null);
            return;
        }
    }

    public void captureInPostRender(boolean flag)
    {
        captureInPostRender = flag;
    }

    private void doCapture()
    {
        allocImage();
        gc.readRaster(raster);
        if(recording)
            writeImage(getDumpPrefix(frame) + frame + ".jpg", raster.getImage().getImage());
        else
            writeImage(filename, raster.getImage().getImage());
        Notify();
    }

    public String getDirectoryName()
    {
        return dir;
    }

    private String getDumpPrefix(int i)
    {
        String s = null;
        if(i < 10)
            s = new String("000");
        else
        if(i < 100)
            s = new String("00");
        else
        if(i < 1000)
            s = new String("0");
        if(s == null)
            return dir + file_separator + prefix;
        else
            return dir + file_separator + prefix + s;
    }

    public String getFilePrefix()
    {
        return prefix;
    }

    public void postRender()
    {
        super.postRender();
        if(captureInPostRender && recording)
            doCapture();
    }

    public void postSwap()
    {
        super.postSwap();
        if(!captureInPostRender && recording)
            doCapture();
        else
        if(takeSnapShot)
        {
            takeSnapShot = false;
            doCapture();
        }
    }

    public synchronized void rendezvous()
    {
        if(recording)
            try
            {
                wait();
            }
            catch(InterruptedException _ex) { }
    }

    public void setDirectoryName(String s)
    {
        dir = s;
    }

    public void setFilePrefix(String s)
    {
        prefix = s;
    }

    public void startRecording()
    {
        recording = true;
        if(bRepaint)
        {
            takeSnapShot = true;
            repaint();
        } else
        {
            doCapture();
        }
    }

    public void stopRecording()
    {
        recording = false;
        Notify();
        System.out.println("Wrote " + frame + " frames");
    }

    public void takeSnapshot()
    {
        if(bRepaint)
            repaint();
        else
            doCapture();
    }

    public void takeSnapshot(String s)
    {
        filename = s;
        if(bRepaint)
        {
            takeSnapShot = true;
            repaint();
        } else
        {
            doCapture();
        }
        s = "image.jpg";
    }

    public void writeImage(String s, BufferedImage bufferedimage)
    {
        System.out.println("Writing " + s);
        try
        {
            FileOutputStream fileoutputstream = new FileOutputStream(s);
            BufferedOutputStream bufferedoutputstream = new BufferedOutputStream(fileoutputstream);
            JPEGImageEncoder jpegimageencoder = JPEGCodec.createJPEGEncoder(bufferedoutputstream);
            JPEGEncodeParam jpegencodeparam = jpegimageencoder.getDefaultJPEGEncodeParam(bufferedimage);
            jpegencodeparam.setQuality(1.0F, true);
            jpegimageencoder.setJPEGEncodeParam(jpegencodeparam);
            jpegimageencoder.encode(bufferedimage);
            bufferedoutputstream.flush();
            fileoutputstream.close();
            frame++;
        }
        catch(Exception exception)
        {
            System.out.println(exception);
        }
    }

    Vector images;
    BufferedImage image;
    Raster raster;
    GraphicsContext3D gc;
    int frame;
    int height;
    int width;
    boolean recording;
    boolean captureInPostRender;
    boolean bRepaint;
    boolean takeSnapShot;
    String prefix;
    String dir;
    String file_separator;
    String filename;
}
