/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   AdjustmentTool.java

package ncsa.j3d.ui.tools;

import java.io.PrintStream;
import java.util.*;
import javax.media.j3d.*;
import javax.vecmath.Point3d;
import ncsa.devices.AdjustableInterface;
// import ncsa.devices.AdjustmentDialog;      // Modified from the decompiled source by Sean Luke, George Mason University  (AdjustmentDialog does not exist)
import ncsa.j3d.ui.PortfolioProperties;

// Referenced classes of package ncsa.j3d.ui.tools:
//            ToolInterface, ToolManagerInterface

public class AdjustmentTool extends Behavior
    implements ToolInterface
{

    public AdjustmentTool()
    {
        conditions = new WakeupOnElapsedFrames(0);
        setSchedulingBounds(new BoundingSphere(new Point3d(), 3.4028234663852886E+38D));
    }

    public String describe()
    {
        return "AdjustmentTool";
    }

    public String describeFunctionality()
    {
        return "Adjusts Input Device";
    }

    public void initialize()
    {
        wakeupOn(conditions);
    }

    public boolean notify(EventObject eventobject)
    {
        return false;
    }

    public void processStimulus(Enumeration enumeration)
    {
    }

    public void setToolManager(ToolManagerInterface toolmanagerinterface)
    {
        Canvas3D canvas3d = toolmanagerinterface.getCanvas();
        ncsa.devices.AdjustmentInterface adjustmentinterface = null;
        int i = 0;
        String s = PortfolioProperties.instance().getProperty("AdjustmentTool.Channel");
        if(s != null)
        {
            javax.media.j3d.InputDevice inputdevice = canvas3d.getView().getPhysicalEnvironment().getSensor(Integer.parseInt(s)).getDevice();
            if(inputdevice instanceof AdjustableInterface)
                adjustmentinterface = ((AdjustableInterface)inputdevice).getAdjustmentInterface();
            else
                System.out.println("AdjustmentTool: " + inputdevice + " does not implement ncsa.devices.AdjustableInterface.");
        }
        s = PortfolioProperties.instance().getProperty("AdjustmentTool.Sensor");
        if(s != null)
            i = Integer.parseInt(s);
        //if(adjustmentinterface != null)    // Modified from the decompiled source by Sean Luke, George Mason University  (AdjustmentDialog does not exist)
        //    dialog = new AdjustmentDialog(adjustmentinterface, i);      // Modified from the decompiled source by Sean Luke, George Mason University  (AdjustmentDialog does not exist)
    }

    //AdjustmentDialog dialog;      // Modified from the decompiled source by Sean Luke, George Mason University  (AdjustmentDialog does not exist)
    protected WakeupOnElapsedFrames conditions;
}
