/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   MouseTool.java

package ncsa.j3d.ui.tools;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.EventObject;
import javax.media.j3d.*;
import javax.vecmath.*;
import ncsa.devices.Fake2DInputDevice;
import ncsa.j3d.PickableTransformGroup;
import ncsa.j3d.SimpleTransformGroup;
import ncsa.j3d.ui.PortfolioProperties;

// Referenced classes of package ncsa.j3d.ui.tools:
//            ToolInterface, ToolManagerInterface

public class MouseTool extends Behavior
    implements ToolInterface
{

    public MouseTool()
    {
        pg = null;
        mode = true;
        lmv = false;
        CUMULATIVE_ROTATE = false;
        TRANSLATION = 0.05F;
        ROTATION = 0.0087266462599716477D;
        scale = 0.01D;
        input = null;
        TRANS = 0;
        ROT = 1;
        MODE = 2;
        conditions = new WakeupOnElapsedFrames(0);
        setSchedulingBounds(new BoundingSphere(new Point3d(), 3.4028234663852886E+38D));
    }

    protected void buttonUp()
    {
        point = null;
        pg = null;
    }

    protected PickRay construct_pickray()
    {
        Transform3D transform3d = new Transform3D();
        Vector3d vector3d = new Vector3d(0.0D, 0.0D, -1D);
        transform3d.transform(vector3d);
        vector3d.normalize();
        Vector3d vector3d1 = new Vector3d();
        transform3d.get(vector3d1);
        Point3d point3d = new Point3d(vector3d1);
        return new PickRay(point3d, vector3d);
    }

    public String describe()
    {
        return "Mouse Tool";
    }

    public String describeFunctionality()
    {
        return "no functionality";
    }

    protected void drag(PickRay pickray, boolean flag, Tuple3d tuple3d)
    {
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickray.get(point3d, vector3d);
        float f = (float)((Tuple3d) (point3d)).x;
        float f1 = (float)((Tuple3d) (point3d)).y;
        float f2 = (float)((Tuple3d) (point3d)).z;
        float f3 = (float)((Tuple3d) (vector3d)).x;
        float f4 = (float)((Tuple3d) (vector3d)).y;
        float f5 = (float)((Tuple3d) (vector3d)).z;
        if(flag)
        {
            line_x = f3;
            line_y = f4;
            line_z = f5;
        }
        double d = (tuple3d.x - (double)f) * (double)line_x + (tuple3d.y - (double)f1) * (double)line_y + (tuple3d.z - (double)f2) * (double)line_z;
        float f6 = f3 * line_x + f4 * line_y + f5 * line_z;
        if((double)f6 == 0.0D)
        {
            return;
        } else
        {
            d /= f6;
            tuple3d.x = (double)f + d * (double)f3;
            tuple3d.y = (double)f1 + d * (double)f4;
            tuple3d.z = (double)f2 + d * (double)f5;
            return;
        }
    }

    protected void drag_depth(double d, Tuple3d tuple3d)
    {
        tuple3d.x = tuple3d.x + d * (double)line_x;
        tuple3d.y = tuple3d.y + d * (double)line_y;
        tuple3d.z = tuple3d.z + d * (double)line_z;
    }

    protected PickRay findRay(int i, int j, TransformGroup transformgroup)
    {
        Point3d point3d = new Point3d();
        canvas.getPixelLocationInImagePlate(i, j, point3d);
        Point3d point3d1 = new Point3d();
        canvas.getCenterEyeInImagePlate(point3d1);
        Transform3D transform3d = new Transform3D();
        canvas.getImagePlateToVworld(transform3d);
        transform3d.transform(point3d);
        transform3d.transform(point3d1);
        if(transformgroup != null)
        {
            Transform3D transform3d1 = new Transform3D();
            transformgroup.getTransform(transform3d1);
            transform3d1.invert();
            transform3d1.transform(point3d);
            transform3d1.transform(point3d1);
        }
        Vector3d vector3d = new Vector3d(((Tuple3d) (point3d)).x - ((Tuple3d) (point3d1)).x, ((Tuple3d) (point3d)).y - ((Tuple3d) (point3d1)).y, ((Tuple3d) (point3d)).z - ((Tuple3d) (point3d1)).z);
        vector3d.normalize();
        PickRay pickray = new PickRay(point3d1, vector3d);
        return pickray;
    }

    protected void firstButton(int i, int j)
    {
        if(mode)
        {
            Vector3d vector3d = pg.get();
            PickRay pickray = findRay(i, j, null);
            drag(pickray, false, vector3d);
            vector3d.add(offset);
            pg.set(vector3d);
        } else
        {
            pg.rotY((double)((float)i - ((Tuple2f) (point)).x) * ROTATION);
            pg.rotX((double)((float)j - ((Tuple2f) (point)).y) * ROTATION);
            if(!CUMULATIVE_ROTATE)
                point = new Point2f(i, j);
        }
    }

    public void initialize()
    {
        wakeupOn(conditions);
    }

    public boolean notify(EventObject eventobject)
    {
        return false;
    }

    protected PickableTransformGroup pick(PickRay pickray)
    {
        SceneGraphPath ascenegraphpath[] = bg.pickAll(pickray);
        if(ascenegraphpath == null)
            return null;
        for(int i = 0; i < ascenegraphpath.length; i++)
        {
            for(int j = 0; j < ascenegraphpath[i].nodeCount(); j++)
            {
                javax.media.j3d.Node node = ascenegraphpath[i].getNode(j);
                if(node instanceof PickableTransformGroup)
                    return (PickableTransformGroup)node;
            }

        }

        return null;
    }

    public void processStimulus(Enumeration enumeration)
    {
        if(input == null)
            return;
        vector = input.getVector3f();
        buttons = input.getButtons();
        if(!lmv && buttons[MODE] != 0)
            mode = mode ^ true;
        lmv = buttons[MODE] != 0;
        if(pg == null && (buttons[TRANS] != 0 || buttons[ROT] != 0))
            select((int)((Tuple3f) (vector)).x, (int)((Tuple3f) (vector)).y);
        if(pg != null)
        {
            if(buttons[TRANS] != 0)
                firstButton((int)((Tuple3f) (vector)).x, (int)((Tuple3f) (vector)).y);
            if(buttons[ROT] != 0)
                secondButton((int)((Tuple3f) (vector)).x, (int)((Tuple3f) (vector)).y);
        }
        if(buttons[TRANS] == 0 && buttons[ROT] == 0)
            buttonUp();
        wakeupOn(conditions);
    }

    protected void secondButton(int i, int j)
    {
        if(mode)
        {
            Vector3d vector3d = pg.get();
            drag_depth((((Tuple2f) (point)).y - (float)j) * TRANSLATION, vector3d);
            pg.set(vector3d);
            point = new Point2f(i, j);
        } else
        {
            pg.rotZ((double)((float)i - ((Tuple2f) (point)).x) * ROTATION);
            if(!CUMULATIVE_ROTATE)
                point = new Point2f(i, j);
        }
    }

    protected void select(int i, int j)
    {
        pg = PickableTransformGroup.selectNode(canvas, bg, i, j);
        if(pg != null)
        {
            offset = pg.get();
            PickRay pickray = findRay(i, j, null);
            drag(pickray, true, offset);
            offset.sub(pg.get(), offset);
        }
        point = new Point2f(i, j);
    }

    public void setToolManager(ToolManagerInterface toolmanagerinterface)
    {
        tmi = toolmanagerinterface;
        setup();
    }

    protected void setup()
    {
        bg = tmi.getBranchGroup();
        canvas = tmi.getCanvas();
        PortfolioProperties portfolioproperties = PortfolioProperties.instance();
        Object obj = portfolioproperties.getObject("MouseTool.Input");
        if(obj == null)
        {
            System.out.println("MouseTool: NOT PROPERLY CONSTRUCTED.");
            System.out.println("Please define MouseTool.Input in ");
            System.out.println("portfolio.properties file.");
            return;
        }
        if(obj instanceof Fake2DInputDevice)
            input = (Fake2DInputDevice)obj;
        else
            System.out.println(String.valueOf(input) + " needs to implement" + " Fake2DInputDevice.");
        bg.addChild(this);
    }

    protected BranchGroup bg;
    protected ToolManagerInterface tmi;
    protected Canvas3D canvas;
    protected int buttons[];
    protected Vector3f vector;
    protected PickableTransformGroup pg;
    protected Point2f point;
    protected boolean mode;
    protected boolean lmv;
    protected Vector3d offset;
    boolean CUMULATIVE_ROTATE;
    protected float TRANSLATION;
    protected double ROTATION;
    protected double scale;
    protected Fake2DInputDevice input;
    protected int TRANS;
    protected int ROT;
    protected int MODE;
    WakeupOnElapsedFrames conditions;
    float line_x;
    float line_y;
    float line_z;
}
