/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   PickTool.java

package ncsa.j3d.ui.tools;

import com.sun.j3d.loaders.Scene;
import java.io.PrintStream;
import java.net.URL;
import java.util.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import ncsa.j3d.PickableTransformGroup;
import ncsa.j3d.SimpleTransformGroup;
import ncsa.j3d.loaders.ModelLoader;
import ncsa.j3d.ui.PortfolioProperties;

// Referenced classes of package ncsa.j3d.ui.tools:
//            ToolInterface, ToolManagerInterface

public class PickTool extends Behavior
    implements ToolInterface
{

    public PickTool()
    {
        group = null;
        original = null;
        undo = null;
        sticky = true;
        SELECT = 0;
        DROP = 1;
        RESET = 2;
        conditions = new WakeupOnElapsedFrames(0);
        transform = new Transform3D();
        setSchedulingBounds(new BoundingSphere(new Point3d(), 3.4028234663852886E+38D));
        tg = new TransformGroup();
        tg.setCapability(18);
        tg.setCapability(17);
    }

    protected void addCursor(BranchGroup branchgroup)
    {
        TransformGroup transformgroup = new TransformGroup();
        Transform3D transform3d = new Transform3D();
        Transform3D transform3d1 = new Transform3D();
        transform3d1.mul(transform3d);
        transformgroup.setTransform(transform3d1);
        if(branchgroup == null)
        {
            LineArray linearray = null;
            linearray = new LineArray(2, 3);
            linearray.setCoordinate(0, new Point3d());
            linearray.setCoordinate(1, new Point3d(0.0D, 0.0D, -300D));
            linearray.setNormal(0, new Vector3f(1.0F, 0.0F, 0.0F));
            linearray.setNormal(1, new Vector3f(1.0F, 0.0F, 0.0F));
            Appearance appearance = new Appearance();
            LineAttributes lineattributes = new LineAttributes();
            lineattributes.setLineWidth(3F);
            appearance.setLineAttributes(lineattributes);
            Material material = new Material();
            material.setDiffuseColor(new Color3f(1.0F, 0.0F, 0.0F));
            appearance.setMaterial(material);
            transformgroup.addChild(new Shape3D(linearray, appearance));
        } else
        {
            transformgroup.addChild(branchgroup);
        }
        tg.addChild(transformgroup);
        tmi.getBranchGroup().addChild(tg);
    }

    protected Transform3D buildTransformToOrigin(Transform3D transform3d)
    {
        Vector3d vector3d = new Vector3d(1.0D, 0.0D, 0.0D);
        Vector3d vector3d1 = new Vector3d();
        Vector3d vector3d2 = new Vector3d(0.0D, 0.0D, 1.0D);
        Vector3d vector3d3 = new Vector3d();
        transform3d.get(vector3d3);
        transform3d.transform(vector3d);
        transform3d.transform(vector3d2);
        vector3d.normalize();
        vector3d2.normalize();
        vector3d1.cross(vector3d2, vector3d);
        vector3d1.normalize();
        vector3d.cross(vector3d1, vector3d2);
        double ad[] = new double[16];
        ad[0] = ((Tuple3d) (vector3d)).x;
        ad[1] = ((Tuple3d) (vector3d)).y;
        ad[2] = ((Tuple3d) (vector3d)).z;
        ad[3] = -((Tuple3d) (vector3d3)).x;
        ad[4] = ((Tuple3d) (vector3d1)).x;
        ad[5] = ((Tuple3d) (vector3d1)).y;
        ad[6] = ((Tuple3d) (vector3d1)).z;
        ad[7] = -((Tuple3d) (vector3d3)).y;
        ad[8] = ((Tuple3d) (vector3d2)).x;
        ad[9] = ((Tuple3d) (vector3d2)).y;
        ad[10] = ((Tuple3d) (vector3d2)).z;
        ad[11] = -((Tuple3d) (vector3d3)).z;
        ad[12] = 0.0D;
        ad[13] = 0.0D;
        ad[14] = 0.0D;
        ad[15] = 1.0D;
        return new Transform3D(ad);
    }

    protected PickRay construct_pickray()
    {
        Transform3D transform3d = new Transform3D();
        tg.getTransform(transform3d);
        Vector3d vector3d = new Vector3d(0.0D, 0.0D, -1D);
        transform3d.transform(vector3d);
        vector3d.normalize();
        Vector3d vector3d1 = new Vector3d();
        transform3d.get(vector3d1);
        Point3d point3d = new Point3d(vector3d1);
        return new PickRay(point3d, vector3d);
    }

    public String describe()
    {
        return "Pick Tool";
    }

    public String describeFunctionality()
    {
        return "Two Modes: Rotate and Translate\ninitial mode is translate\nspacebar toggles between modes\n\nTranslate mode:\nLeft mouse translates in x and y\nMiddle mouse translates in z\n\nRotate mode:\nLeft mouse rotates around x and y\nMiddles mouse rotates around z";
    }

    public void initialize()
    {
        wakeupOn(conditions);
    }

    public boolean notify(EventObject eventobject)
    {
        return false;
    }

    protected PickableTransformGroup pick(PickRay pickray)
    {
        SceneGraphPath ascenegraphpath[] = bg.pickAll(pickray);
        if(ascenegraphpath == null)
            return null;
        for(int i = 0; i < ascenegraphpath.length; i++)
        {
            for(int j = 0; j < ascenegraphpath[i].nodeCount(); j++)
            {
                javax.media.j3d.Node node = ascenegraphpath[i].getNode(j);
                if(node instanceof PickableTransformGroup)
                    return (PickableTransformGroup)node;
            }

        }

        return null;
    }

    protected void processButtonSensor()
    {
        Transform3D transform3d = new Transform3D();
        buttonsensor.getRead(transform3d);
        buttonsensor.lastButtons(buttons);
        if(SELECT < buttons.length && buttons[SELECT] != 0 && group == null)
        {
            PickRay pickray = construct_pickray();
            group = pick(pickray);
            if(group != null)
            {
                original = new Transform3D();
                group.get(original);
                undo = buildTransformToOrigin(transform);
            }
        }
        if(SELECT < buttons.length && !sticky && buttons[SELECT] == 0)
            group = null;
        if(DROP < buttons.length && buttons[DROP] != 0 && sticky)
            group = null;
        if(RESET < buttons.length && buttons[RESET] != 0 && group != null)
        {
            group.set(original);
            original = new Transform3D();
            group.get(original);
            undo = buildTransformToOrigin(transform);
        }
    }

    protected void processGroup()
    {
        if(group == null)
        {
            return;
        } else
        {
            Transform3D transform3d = new Transform3D(transform);
            Vector3d vector3d = new Vector3d();
            transform3d.get(vector3d);
            transform3d.setTranslation(new Vector3d());
            Transform3D transform3d1 = new Transform3D(undo);
            Vector3d vector3d1 = new Vector3d();
            transform3d1.get(vector3d1);
            transform3d1.setTranslation(new Vector3d());
            Transform3D transform3d2 = new Transform3D();
            transform3d2.mul(transform3d, transform3d1);
            Transform3D transform3d3 = new Transform3D(original);
            transform3d3.setTranslation(new Vector3d());
            transform3d2.mul(transform3d3);
            Vector3d vector3d2 = new Vector3d();
            original.get(vector3d2);
            vector3d2.add(vector3d1);
            vector3d2.add(vector3d);
            transform3d2.setTranslation(vector3d2);
            group.set(transform3d2);
            return;
        }
    }

    public synchronized void processStimulus(Enumeration enumeration)
    {
        sensor.getRead(transform);
        tg.setTransform(transform);
        processButtonSensor();
        processGroup();
        wakeupOn(conditions);
    }

    public void setToolManager(ToolManagerInterface toolmanagerinterface)
    {
        tmi = toolmanagerinterface;
        setup();
    }

    protected void setup()
    {
        bg = tmi.getBranchGroup();
        canvas = tmi.getCanvas();
        PortfolioProperties portfolioproperties = PortfolioProperties.instance();
        String s = portfolioproperties.getProperty("PickTool.Channel");
        if(s != null)
        {
            sensor = tmi.getCanvas().getView().getPhysicalEnvironment().getSensor(Integer.parseInt(s));
            tmi.getBranchGroup().addChild(this);
            String s1 = portfolioproperties.getProperty("PickTool.Cursor");
            BranchGroup branchgroup = null;
            if(s1 != null)
            {
                ModelLoader modelloader = new ModelLoader();
                try
                {
                    URL url = new URL(s1);
                    Scene scene = modelloader.load(url);
                    branchgroup = scene.getSceneGroup();
                }
                catch(Exception exception)
                {
                    System.out.println(exception);
                }
            }
            addCursor(branchgroup);
        } else
        {
            System.out.println("There is no Device at " + s);
        }
        String s2 = portfolioproperties.getProperty("PickTool.Button.Channel");
        if(s2 == null)
            s2 = s;
        if(s2 != null)
        {
            buttonsensor = tmi.getCanvas().getView().getPhysicalEnvironment().getSensor(Integer.parseInt(s2));
            buttons = new int[buttonsensor.getSensorButtonCount()];
        }
        String s3 = portfolioproperties.getProperty("PickTool.Sticky");
        if(s3 != null)
            if(s3.equalsIgnoreCase("true"))
                sticky = true;
            else
                sticky = false;
    }

    protected BranchGroup bg;
    protected TransformGroup tg;
    protected ToolManagerInterface tmi;
    protected Canvas3D canvas;
    protected Sensor sensor;
    protected Sensor buttonsensor;
    protected int buttons[];
    protected PickableTransformGroup group;
    protected Transform3D original;
    protected Transform3D undo;
    boolean sticky;
    protected int SELECT;
    protected int DROP;
    protected int RESET;
    WakeupOnElapsedFrames conditions;
    Transform3D transform;
}
