/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SensorRecordTool.java

package ncsa.j3d.ui.tools;

import java.io.PrintStream;
import java.util.*;
import javax.media.j3d.*;
import javax.vecmath.Point3d;
import ncsa.j3d.loaders.play.PlayWriter;
import ncsa.j3d.loaders.play.directives.SensorDirective;
import ncsa.j3d.ui.PortfolioProperties;

// Referenced classes of package ncsa.j3d.ui.tools:
//            ToolInterface, ToolManagerInterface

public class SensorRecordTool extends Behavior
    implements ToolInterface
{

    public SensorRecordTool()
    {
        conditions = new WakeupOnElapsedFrames(0);
        olddir = null;
        setSchedulingBounds(new BoundingSphere(new Point3d(), 3.4028234663852886E+38D));
    }

    public String describe()
    {
        return "SensorRecordTool";
    }

    public String describeFunctionality()
    {
        return "Records the Sensor";
    }

    public void initialize()
    {
        wakeupOn(conditions);
    }

    public boolean notify(EventObject eventobject)
    {
        return false;
    }

    public void processStimulus(Enumeration enumeration)
    {
        SensorDirective sensordirective = new SensorDirective(sensor);
        if(!sensordirective.equals(olddir))
        {
            PlayWriter.write(sensordirective);
            olddir = sensordirective;
        }
        wakeupOn(conditions);
    }

    public void setToolManager(ToolManagerInterface toolmanagerinterface)
    {
        Canvas3D canvas3d = toolmanagerinterface.getCanvas();
        String s = PortfolioProperties.instance().getProperty("SensorRecordTool" + instances++ + "Channel");
        if(s != null)
        {
            sensor = canvas3d.getView().getPhysicalEnvironment().getSensor(Integer.parseInt(s));
            toolmanagerinterface.getBranchGroup().addChild(this);
        } else
        {
            System.out.println("SensorRecordTool" + (instances - 1) + "Channel is not defined in portfolio.properties file. What do you expect me to record?");
        }
    }

    protected WakeupOnElapsedFrames conditions;
    Sensor sensor;
    static int instances = 0;
    SensorDirective olddir;

}
