/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   Tool.java

package ncsa.j3d.ui.tools;

import java.awt.AWTEvent;
import java.awt.event.*;
import java.util.EventObject;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;

// Referenced classes of package ncsa.j3d.ui.tools:
//            ToolInterface, ToolManagerInterface

public abstract class Tool
    implements ToolInterface
{

    public Tool()
    {
    }

    public Tool(Canvas3D canvas3d, BranchGroup branchgroup)
    {
        canvas = canvas3d;
        bg = branchgroup;
    }

    protected boolean LeftMouseDragged(MouseEvent mouseevent)
    {
        return def();
    }

    protected boolean LeftMousePressed(MouseEvent mouseevent)
    {
        return def();
    }

    protected boolean LeftMouseReleased(MouseEvent mouseevent)
    {
        return def();
    }

    protected boolean MiddleMouseDragged(MouseEvent mouseevent)
    {
        return def();
    }

    protected boolean MiddleMousePressed(MouseEvent mouseevent)
    {
        return def();
    }

    protected boolean MiddleMouseReleased(MouseEvent mouseevent)
    {
        return def();
    }

    protected boolean MouseDragged(MouseEvent mouseevent)
    {
        if(left(mouseevent))
            return LeftMouseDragged(mouseevent);
        if(middle(mouseevent))
            return MiddleMouseDragged(mouseevent);
        if(right(mouseevent))
            return RightMouseDragged(mouseevent);
        else
            return false;
    }

    protected boolean MousePressed(MouseEvent mouseevent)
    {
        if(left(mouseevent))
            return LeftMousePressed(mouseevent);
        if(middle(mouseevent))
            return MiddleMousePressed(mouseevent);
        if(right(mouseevent))
            return RightMousePressed(mouseevent);
        else
            return false;
    }

    protected boolean MouseReleased(MouseEvent mouseevent)
    {
        if(left(mouseevent))
            return LeftMouseReleased(mouseevent);
        if(middle(mouseevent))
            return MiddleMouseReleased(mouseevent);
        if(right(mouseevent))
            return RightMouseReleased(mouseevent);
        else
            return false;
    }

    protected boolean RightMouseDragged(MouseEvent mouseevent)
    {
        return def();
    }

    protected boolean RightMousePressed(MouseEvent mouseevent)
    {
        return def();
    }

    protected boolean RightMouseReleased(MouseEvent mouseevent)
    {
        return def();
    }

    protected boolean def()
    {
        return false;
    }

    public String describe()
    {
        return "Tool";
    }

    public String describeFunctionality()
    {
        return "No description availiable";
    }

    protected abstract void initialize();

    protected boolean keyboard(KeyEvent keyevent)
    {
        return false;
    }

    public static boolean left(MouseEvent mouseevent)
    {
        return !middle(mouseevent) && !right(mouseevent);
    }

    public static boolean middle(MouseEvent mouseevent)
    {
        return (8 & mouseevent.getModifiers()) > 0;
    }

    protected boolean mouse(MouseEvent mouseevent)
    {
        switch(mouseevent.getID())
        {
        case 501: 
            return MousePressed(mouseevent);

        case 506: 
            return MouseDragged(mouseevent);

        case 502: 
            return MouseReleased(mouseevent);

        case 503: 
        case 504: 
        case 505: 
        default:
            return false;
        }
    }

    public boolean notify(EventObject eventobject)
    {
        if(eventobject instanceof MouseEvent)
            return mouse((MouseEvent)eventobject);
        if(eventobject instanceof KeyEvent)
            return keyboard((KeyEvent)eventobject);
        else
            return false;
    }

    public static boolean right(MouseEvent mouseevent)
    {
        return (4 & mouseevent.getModifiers()) > 0;
    }

    public void setBranchGroup(BranchGroup branchgroup)
    {
        bg = branchgroup;
    }

    public void setCanvas(Canvas3D canvas3d)
    {
        canvas = canvas3d;
    }

    public void setToolManager(ToolManagerInterface toolmanagerinterface)
    {
        manager = toolmanagerinterface;
        initialize();
    }

    protected BranchGroup bg;
    protected Canvas3D canvas;
    protected ToolManagerInterface manager;
}
