/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ToolManager.java

package ncsa.j3d.ui.tools;

import java.io.PrintStream;
import java.util.EventObject;
import java.util.Properties;
import javax.media.j3d.*;
import ncsa.j3d.loaders.play.PlayWriter;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.events.*;

// Referenced classes of package ncsa.j3d.ui.tools:
//            ReceiverList, ToolInterface, ToolManagerInterface

public class ToolManager
    implements ToolManagerInterface
{

    protected ToolManager()
    {
        inactive = new ReceiverList();
        receivers = new ReceiverList();
        tools = new ReceiverList();
        setup = false;
        toolGroup = makeBranchGroup();
        setupRecord();
    }

    public void addActive(PortfolioEventReceiver portfolioeventreceiver)
    {
        if(portfolioeventreceiver instanceof ToolInterface)
            setActiveTool((ToolInterface)portfolioeventreceiver);
        else
            receivers.add(portfolioeventreceiver);
    }

    public void addEventSource(Object obj)
    {
        EventManager.instance().addEventSource(obj);
    }

    public void addInactive(PortfolioEventReceiver portfolioeventreceiver)
    {
        if(portfolioeventreceiver instanceof ToolInterface)
            tools.add(portfolioeventreceiver);
        else
            inactive.add(portfolioeventreceiver);
    }

    public void addPortfolioEvent(PortfolioEvent portfolioevent)
    {
        EventManager.instance().addEvent(portfolioevent);
    }

    protected void clearToolGroup()
    {
        toolGroup.detach();
        for(int i = toolGroup.numChildren() - 1; i >= 0; i--)
            toolGroup.removeChild(i);

        branchGroup.addChild(toolGroup);
    }

    protected ToolInterface configureTool(ToolInterface toolinterface)
    {
        toolinterface.setToolManager(this);
        return toolinterface;
    }

    ToolInterface getActiveTool()
    {
        return activeTool;
    }

    public BranchGroup getBranchGroup()
    {
        return branchGroup;
    }

    public Canvas3D getCanvas()
    {
        return canvas;
    }

    ReceiverList getInactiveReceiverList()
    {
        return inactive;
    }

    public String[] getToolNames()
    {
        String as[] = new String[tools.getSize()];
        for(int i = 0; i < as.length; i++)
            as[i] = new String(((ToolInterface)tools.get(i)).describe());

        return as;
    }

    public TransformGroup getViewTransform()
    {
        return viewTransform;
    }

    public static ToolManager instance()
    {
        if(instance == null)
            instance = new ToolManager();
        return instance;
    }

    public void loadTools()
    {
        loadTools(PortfolioProperties.instance());
    }

    protected void loadTools(PortfolioProperties portfolioproperties)
    {
        Object aobj[] = portfolioproperties.getObjects("Tool");
        for(int i = 0; i < aobj.length; i++)
            if(aobj[i] instanceof ToolInterface)
                addInactive(configureTool((ToolInterface)aobj[i]));
            else
                System.out.println("ToolManager could not loadTools because " + aobj[i] + " does not implement ncsa.j3d.ui.tools.ToolInterface.");

    }

    public void makeActive(PortfolioEventReceiver portfolioeventreceiver)
    {
        if(portfolioeventreceiver instanceof ToolInterface)
        {
            setActiveTool((ToolInterface)portfolioeventreceiver);
        } else
        {
            boolean flag = inactive.remove(portfolioeventreceiver);
            receivers.add(portfolioeventreceiver);
        }
    }

    protected BranchGroup makeBranchGroup()
    {
        BranchGroup branchgroup = new BranchGroup();
        branchgroup.setCapability(1);
        branchgroup.setCapability(14);
        branchgroup.setCapability(12);
        branchgroup.setCapability(13);
        branchgroup.setCapability(17);
        branchgroup.setCapability(5);
        return branchgroup;
    }

    public void makeInactive(PortfolioEventReceiver portfolioeventreceiver)
    {
        boolean flag = receivers.remove(portfolioeventreceiver);
        if(!(portfolioeventreceiver instanceof ToolInterface))
            inactive.add(portfolioeventreceiver);
    }

    public boolean notify(EventObject eventobject)
    {
        if(activeTool != null && activeTool.notify(eventobject))
            return true;
        else
            return receivers.notify(eventobject);
    }

    public void remove(PortfolioEventReceiver portfolioeventreceiver)
    {
    }

    public void setActiveTool(int i)
    {
        ToolInterface toolinterface = (ToolInterface)tools.get(i);
        if(toolinterface != null)
            setActiveTool(toolinterface);
    }

    public void setActiveTool(ToolInterface toolinterface)
    {
        if(activeTool instanceof Node)
            clearToolGroup();
        tools.add(toolinterface);
        activeTool = toolinterface;
    }

    public void setBranchGroup(BranchGroup branchgroup)
    {
        if(branchGroup == null)
        {
            branchGroup = branchgroup;
            branchGroup.addChild(toolGroup);
        }
    }

    public void setCanvas(Canvas3D canvas3d)
    {
        if(canvas == null)
            canvas = canvas3d;
    }

    public void setViewTransform(TransformGroup transformgroup)
    {
        if(viewTransform == null)
            viewTransform = transformgroup;
    }

    protected void setupRecord()
    {
        PortfolioProperties portfolioproperties = PortfolioProperties.instance();
        String s = portfolioproperties.getProperty("Record");
        if(s == null || s.equalsIgnoreCase("false"))
            return;
        s = portfolioproperties.getProperty("RecordFile");
        if(s != null)
        {
            PlayWriter.open(s);
            System.out.println("PlayWriter writing to " + s + ".");
        } else
        {
            System.out.println("ERROR: Record is turned on and RecordFile is not properly defined in portfolio.properties file.");
        }
    }

    ReceiverList inactive;
    ReceiverList receivers;
    ReceiverList tools;
    ToolInterface activeTool;
    BranchGroup branchGroup;
    BranchGroup toolGroup;
    TransformGroup viewTransform;
    Canvas3D canvas;
    boolean setup;
    protected static ToolManager instance = null;

}
