/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ViewTool.java

package ncsa.j3d.ui.tools;

import java.io.PrintStream;
import java.util.*;
import javax.media.j3d.*;
import javax.vecmath.Point3d;
import ncsa.j3d.ui.PortfolioProperties;

// Referenced classes of package ncsa.j3d.ui.tools:
//            ToolInterface, ToolManagerInterface

public class ViewTool extends Behavior
    implements ToolInterface
{

    public ViewTool()
    {
        conditions = new WakeupOnElapsedFrames(0);
        transform = new Transform3D();
        setSchedulingBounds(new BoundingSphere(new Point3d(), 3.4028234663852886E+38D));
    }

    public String describe()
    {
        return "View Tool";
    }

    public String describeFunctionality()
    {
        return "No Functionality";
    }

    public void initialize()
    {
        wakeupOn(conditions);
    }

    public boolean notify(EventObject eventobject)
    {
        return false;
    }

    public void processStimulus(Enumeration enumeration)
    {
        sensor.getRead(transform);
        transGroup.setTransform(transform);
        wakeupOn(conditions);
    }

    public void setToolManager(ToolManagerInterface toolmanagerinterface)
    {
        tmi = toolmanagerinterface;
        setup();
    }

    protected void setup()
    {
        transGroup = tmi.getViewTransform();
        Canvas3D canvas3d = tmi.getCanvas();
        javax.media.j3d.BranchGroup branchgroup = tmi.getBranchGroup();
        String s = PortfolioProperties.instance().getProperty("ViewTool.Channel");
        if(s != null)
        {
            sensor = canvas3d.getView().getPhysicalEnvironment().getSensor(Integer.parseInt(s));
            branchgroup.addChild(this);
        } else
        {
            System.out.println("Please specify ViewToolChannel in portfolio.properties");
        }
    }

    protected TransformGroup transGroup;
    protected ToolManagerInterface tmi;
    protected Sensor sensor;
    protected WakeupOnElapsedFrames conditions;
    protected Transform3D transform;
}
