/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SJSlider.java

package ncsa.j3d.ui.widgets;

import com.sun.j3d.utils.geometry.Sphere;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.util.*;
import javax.media.j3d.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.*;
import ncsa.j3d.SimpleTransformGroup;
import ncsa.j3d.ui.widgets.event.TransformChangedEvent;
import ncsa.j3d.ui.widgets.event.TransformChangedListener;
import ncsa.j3d.ui.widgets.event.TransformWatcher;

// Referenced classes of package ncsa.j3d.ui.widgets:
//            SJComponent, HasNode, HasValue, RestrictivePickableTransformGroup, 
//            SAbstractButton, SContainer, SJButton

public class SJSlider extends SJComponent
    implements HasNode, TransformChangedListener, ActionListener, HasValue
{

    public SJSlider()
    {
        this(0, 100, 50);
    }

    public SJSlider(int i, int j)
    {
        this(i, j, (j - i) / 2);
    }

    public SJSlider(int i, int j, int k)
    {
        orientation = 1;
        changeListeners = new Vector();
        max = 0;
        min = 0;
        value = 0;
        transformWatcher = null;
        slider = null;
        minimum = null;
        maximum = null;
        center = null;
        minButton = null;
        maxButton = null;
        setMinimum(i);
        setMaximum(j);
        value = k;
    }

    public void actionPerformed(ActionEvent actionevent)
    {
        Object obj = actionevent.getSource();
        if(obj == maxButton)
            setValue((int)Math.ceil(getValueD()) + 1);
        if(obj == minButton)
            setValue((int)Math.floor(getValueD()) - 1);
    }

    public void addChangeListener(ChangeListener changelistener)
    {
        changeListeners.addElement(changelistener);
    }

    protected Node defaultNode()
    {
        Sphere sphere = new Sphere(0.5F, new Appearance());
        sphere.setCapability(1);
        return sphere;
    }

    protected void fireStateChanged()
    {
        ChangeEvent changeevent = new ChangeEvent(this);
        for(Enumeration enumeration = changeListeners.elements(); enumeration.hasMoreElements(); ((ChangeListener)enumeration.nextElement()).stateChanged(changeevent));
    }

    public int getMaximum()
    {
        return max;
    }

    public int getMinimum()
    {
        return min;
    }

    public Node getNode()
    {
        if(group == null)
        {
            setup();
            fireStateChanged();
        }
        return group;
    }

    protected double getPercentage()
    {
        return (getSliderLocation() + 5D) / 10D;
    }

    protected double getSliderLocation()
    {
        Vector3d vector3d = slider.get();
        switch(orientation)
        {
        case 1: // '\001'
            return ((Tuple3d) (vector3d)).x;

        case 0: // '\0'
            return ((Tuple3d) (vector3d)).y;

        case 2: // '\002'
            return ((Tuple3d) (vector3d)).z;
        }
        System.out.println("invalid orientation for " + this);
        return 0.0D;
    }

    public int getValue()
    {
        return (int)(getPercentage() * (double)(max - min)) + min;
    }

    protected double getValueD()
    {
        return getPercentage() * (double)(max - min) + (double)min;
    }

    protected Vector3d maximumOffset()
    {
        switch(orientation)
        {
        case 1: // '\001'
            return new Vector3d(5D, 0.0D, 0.0D);

        case 0: // '\0'
            return new Vector3d(0.0D, 5D, 0.0D);

        case 2: // '\002'
            return new Vector3d(0.0D, 0.0D, 5D);
        }
        System.out.println("Invalid orientation for " + this);
        return null;
    }

    protected Vector3d minimumOffset()
    {
        switch(orientation)
        {
        case 1: // '\001'
            return new Vector3d(-5D, 0.0D, 0.0D);

        case 0: // '\0'
            return new Vector3d(0.0D, -5D, 0.0D);

        case 2: // '\002'
            return new Vector3d(0.0D, 0.0D, -5D);
        }
        System.out.println("Invalid orientation for " + this);
        return null;
    }

    public void removeChangeListener(ChangeListener changelistener)
    {
        changeListeners.removeElement(changelistener);
    }

    protected void restrict(RestrictivePickableTransformGroup restrictivepickabletransformgroup)
    {
        switch(orientation)
        {
        case 1: // '\001'
            slider.setXMax(5D);
            slider.setXMin(-5D);
            break;

        case 0: // '\0'
            slider.setYMax(5D);
            slider.setYMin(-5D);
            break;

        case 2: // '\002'
            slider.setZMax(5D);
            slider.setZMin(-5D);
            break;

        default:
            System.out.println("Invalid orientation for :" + this);
            break;
        }
    }

    public void setMaximum(int i)
    {
        max = i;
    }

    public void setMaximumNode(Node node)
    {
        maximum = node;
    }

    public void setMinimum(int i)
    {
        min = i;
    }

    public void setMinimumNode(Node node)
    {
        minimum = node;
    }

    public void setOrientation(int i)
    {
        i = i >= 0 ? i : 0;
        i = i <= 2 ? i : 2;
        orientation = i;
    }

    public void setSlide(Node node)
    {
        center = node;
    }

    protected void setSliderLocation(double d)
    {
        Vector3d vector3d = slider.get();
        switch(orientation)
        {
        case 1: // '\001'
            vector3d.x = d;
            break;

        case 0: // '\0'
            vector3d.y = d;
            break;

        case 2: // '\002'
            vector3d.z = d;
            break;

        default:
            System.out.println("invalid orientation for " + this);
            break;
        }
        slider.set(vector3d);
    }

    public void setValue(int i)
    {
        i = Math.min(max, i);
        i = Math.max(min, i);
        double d = ((double)i - (double)min) / (double)(max - min);
        double d1 = 10D * d - 5D;
        setSliderLocation(d1);
    }

    protected void setup()
    {
        group = new Group();
        group.addChild(setupMinimumBlock());
        group.addChild(setupMaximumBlock());
        group.addChild(setupSlider());
    }

    protected Node setupMaximumBlock()
    {
        TransformGroup transformgroup = new TransformGroup();
        Transform3D transform3d = new Transform3D();
        transform3d.set(maximumOffset());
        transformgroup.setTransform(transform3d);
        maxButton = new SJButton(maximum == null ? defaultNode() : maximum);
        maxButton.addActionListener(this);
        add(maxButton);
        transformgroup.addChild(maxButton.getNode());
        return transformgroup;
    }

    protected Node setupMinimumBlock()
    {
        TransformGroup transformgroup = new TransformGroup();
        Transform3D transform3d = new Transform3D();
        transform3d.set(minimumOffset());
        transformgroup.setTransform(transform3d);
        minButton = new SJButton(minimum == null ? defaultNode() : minimum);
        minButton.addActionListener(this);
        add(minButton);
        transformgroup.addChild(minButton.getNode());
        return transformgroup;
    }

    protected Node setupSlider()
    {
        slider = new RestrictivePickableTransformGroup(new Vector3f(0.0F, 0.0F, 0.0F));
        restrict(slider);
        slider.addChild(center == null ? defaultNode() : center);
        transformWatcher = new TransformWatcher(slider);
        transformWatcher.addTransformListener(this);
        slider.addChild(transformWatcher);
        return slider;
    }

    public void transformChanged(TransformChangedEvent transformchangedevent)
    {
        fireStateChanged();
    }

    static final int magnitude = 5;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int DEPTH = 2;
    protected int orientation;
    protected Vector changeListeners;
    protected int max;
    protected int min;
    protected int value;
    protected Group group;
    protected TransformWatcher transformWatcher;
    protected RestrictivePickableTransformGroup slider;
    protected Node minimum;
    protected Node maximum;
    protected Node center;
    protected SJButton minButton;
    protected SJButton maxButton;
}
