/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ScrollingTextHUD.java

package ncsa.j3d.ui.widgets;

import com.sun.j3d.utils.geometry.Text2D;
import java.awt.Font;
import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

// Referenced classes of package ncsa.j3d.ui.widgets:
//            HeadsUpDisplay

public class ScrollingTextHUD extends HeadsUpDisplay
{

    public ScrollingTextHUD(TransformGroup transformgroup)
    {
        super(transformgroup);
    }

    public void add(String s)
    {
        t5 = t4;
        t4 = t3;
        t3 = t2;
        t2 = t1;
        t1 = makeTransform(0.0D);
        t1.addChild(makeText(s));
        draw(t1);
    }

    protected void draw(TransformGroup transformgroup)
    {
        disconnect();
        super.detach.removeChild(0);
        super.detach.addChild(transformgroup);
        connect();
        set();
    }

    protected Shape3D makeText(String s)
    {
        return new Text2D(s, new Color3f(0.0F, 0.0F, 1.0F), "Serif", 60, 1);
    }

    public TransformGroup makeTransform(double d)
    {
        TransformGroup transformgroup = new TransformGroup();
        transformgroup.setCapability(14);
        transformgroup.setCapability(13);
        transformgroup.setCapability(12);
        transformgroup.setCapability(18);
        Transform3D transform3d = new Transform3D();
        transform3d.set(scale);
        transform3d.setTranslation(new Vector3d(x_offset, (double)y_offset + d, z_offset));
        transformgroup.setTransform(transform3d);
        return transformgroup;
    }

    protected void set()
    {
        t1.setTransform(transform(ys + ys + ys + ys));
        t2.setTransform(transform(ys + ys + ys));
        t3.setTransform(transform(ys + ys));
        t4.setTransform(transform(ys));
        t5.setTransform(transform(0.0D));
    }

    protected void setup()
    {
        super.setup();
        t1 = makeTransform(0.0D);
        t2 = makeTransform(ys);
        t3 = makeTransform(ys + ys);
        t4 = makeTransform(ys + ys + ys);
        t5 = makeTransform(ys + ys + ys + ys);
        super.detach.addChild(t5);
        super.detach.addChild(t4);
        super.detach.addChild(t3);
        super.detach.addChild(t2);
        super.detach.addChild(t1);
    }

    protected Transform3D transform(double d)
    {
        Transform3D transform3d = new Transform3D();
        transform3d.set(scale);
        transform3d.setTranslation(new Vector3d(x_offset, (double)y_offset + d, z_offset));
        return transform3d;
    }

    TransformGroup t1;
    TransformGroup t2;
    TransformGroup t3;
    TransformGroup t4;
    TransformGroup t5;
    static float x_offset = -0.025F;
    static float y_offset = -0.02F;
    static float z_offset = -0.09F;
    static float ys = -0.0021F;
    static float scale = 0.012F;

}
