/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   WidgetManager.java

package ncsa.j3d.ui.widgets;

import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.io.PrintStream;
import java.util.EventObject;
import java.util.Vector;
import javax.media.j3d.*;
import javax.vecmath.*;
import ncsa.j3d.ui.events.EventManager;
import ncsa.j3d.ui.events.PortfolioEventReceiver;
import ncsa.j3d.ui.widgets.event.SFocusEvent;

// Referenced classes of package ncsa.j3d.ui.widgets:
//            HasNode, HasStates

public class WidgetManager
    implements PortfolioEventReceiver
{

    public WidgetManager(Canvas3D canvas3d)
    {
        windows = new Vector();
        object = null;
        connected = false;
        instance = null;
        canvas = canvas3d;
        group = new BranchGroup();
        group.setCapability(17);
        group.setCapability(14);
        group.setCapability(12);
        group.setCapability(13);
        EventManager.instance().addEventReceiver(this);
    }

    public void add(HasNode hasnode)
    {
        windows.addElement(hasnode);
        disconnect();
        group.addChild(hasnode.getNode());
        connect();
    }

    protected void connect()
    {
        if(fixed != null && !connected)
        {
            fixed.addChild(group);
            connected = true;
        }
    }

    protected void disconnect()
    {
        if(connected)
            group.detach();
        connected = false;
    }

    protected boolean mouse(MouseEvent mouseevent)
    {
        HasStates hasstates = selectNode(canvas, fixed, mouseevent.getX(), mouseevent.getY());
        switch(mouseevent.getID())
        {
        case 503: 
        case 504: 
        case 505: 
        default:
            break;

        case 501: 
            if(object != null)
                object.focusLost(new SFocusEvent(this, 1));
            object = hasstates;
            if(object != null)
            {
                object.focusGained(new SFocusEvent(this, 0));
                return true;
            } else
            {
                return false;
            }

        case 506: 
            if(object != null)
                return true;
            break;

        case 502: 
            if(hasstates != null && hasstates == object)
            {
                object.selected();
                return true;
            }
            break;
        }
        return false;
    }

    public boolean notify(EventObject eventobject)
    {
        if(eventobject instanceof MouseEvent)
            return mouse((MouseEvent)eventobject);
        else
            return false;
    }

    public HasStates selectNode(Canvas3D canvas3d, BranchGroup branchgroup, int i, int j)
    {
        Transform3D transform3d = new Transform3D();
        Point3d point3d = new Point3d();
        Point3d point3d1 = new Point3d();
        Vector3d vector3d = new Vector3d();
        HasStates hasstates = null;
        PickRay pickray = new PickRay();
        System.out.println("canvas = " + canvas3d);
        canvas3d.getCenterEyeInImagePlate(point3d);
        canvas3d.getPixelLocationInImagePlate(i, j, point3d1);
        canvas3d.getImagePlateToVworld(transform3d);
        transform3d.transform(point3d);
        transform3d.transform(point3d1);
        vector3d.sub(point3d1, point3d);
        vector3d.normalize();
        pickray.set(point3d1, vector3d);
        SceneGraphPath ascenegraphpath[] = branchgroup.pickAllSorted(pickray);
        if(ascenegraphpath != null)
        {
            for(int k = 0; k < ascenegraphpath.length; k++)
            {
                if(ascenegraphpath[k] == null)
                    continue;
                for(int l = 0; l < ascenegraphpath[k].nodeCount(); l++)
                {
                    javax.media.j3d.Node node = ascenegraphpath[k].getNode(l);
                    if(!(node instanceof HasStates))
                        continue;
                    hasstates = (HasStates)node;
                    break;
                }

                if(hasstates != null)
                    break;
            }

        }
        return hasstates;
    }

    public void setBranchGroup(BranchGroup branchgroup)
    {
        fixed = branchgroup;
        connect();
    }

    public void setCanvas(Canvas3D canvas3d)
    {
        canvas = canvas3d;
    }

    protected Vector windows;
    protected BranchGroup fixed;
    protected BranchGroup group;
    protected Canvas3D canvas;
    protected HasStates object;
    protected boolean connected;
    protected WidgetManager instance;
}
