/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   TransformWatcher.java

package ncsa.j3d.ui.widgets.event;

import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.*;

// Referenced classes of package ncsa.j3d.ui.widgets.event:
//            TransformChangedEvent, TransformChangedListener

public class TransformWatcher extends Behavior
{

    public TransformWatcher(TransformGroup transformgroup)
    {
        transformWatchers = new Vector();
        skip = 0;
        transform = transformgroup;
        BoundingSphere boundingsphere = new BoundingSphere();
        boundingsphere.setRadius(1000D);
        setSchedulingBounds(boundingsphere);
    }

    public void addTransformListener(TransformChangedListener transformchangedlistener)
    {
        transformWatchers.addElement(transformchangedlistener);
    }

    public void initialize()
    {
        criterion = new WakeupOnTransformChange(transform);
        wakeupOn(criterion);
    }

    public void notifyAllTransformWatchers()
    {
        TransformChangedEvent transformchangedevent = new TransformChangedEvent(this, transform);
        for(Enumeration enumeration = transformWatchers.elements(); enumeration.hasMoreElements(); ((TransformChangedListener)enumeration.nextElement()).transformChanged(transformchangedevent));
    }

    public void processStimulus(Enumeration enumeration)
    {
        wakeupOn(criterion);
        if(skip == 0)
            notifyAllTransformWatchers();
        skip = skip <= 0 ? 0 : skip - 1;
    }

    public void removeTransformListener(TransformChangedListener transformchangedlistener)
    {
        transformWatchers.removeElement(transformchangedlistener);
    }

    public void skipOne()
    {
        skip++;
    }

    TransformGroup transform;
    WakeupCriterion criterion;
    Vector transformWatchers;
    int skip;
}
