/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   MulticastHandler.java

package ncsa.net;

import java.io.*;
import java.net.*;

// Referenced classes of package ncsa.net:
//            Handler, Customer

public class MulticastHandler extends Handler
    implements Runnable
{

    public MulticastHandler(String s, int i, Customer customer1)
    {
        super(s, i);
        sock = null;
        group = null;
        thread = null;
        stopped = false;
        loopback = true;
        customer = customer1;
    }

    public void begin()
    {
        try
        {
            group = InetAddress.getByName(super.address);
        }
        catch(UnknownHostException unknownhostexception)
        {
            System.out.println(unknownhostexception);
            return;
        }
        try
        {
            sock = new MulticastSocket(super.port);
            sock.joinGroup(group);
        }
        catch(IOException ioexception)
        {
            System.out.println(ioexception);
            return;
        }
        thread = new Thread(this);
        thread.start();
    }

    public void end()
    {
        try
        {
            stopped = true;
            sock.leaveGroup(group);
            sock.close();
            thread.interrupt();
        }
        catch(IOException _ex) { }
    }

    public void run()
    {
        try
        {
            MulticastSocket multicastsocket = new MulticastSocket(super.port);
            multicastsocket.joinGroup(group);
            byte abyte0[] = new byte[1024];
            do
            {
                DatagramPacket datagrampacket;
                do
                {
                    if(stopped)
                        return;
                    datagrampacket = new DatagramPacket(abyte0, abyte0.length);
                    multicastsocket.receive(datagrampacket);
                } while(!loopback && InetAddress.getLocalHost().equals(datagrampacket.getAddress()));
                customer.consume(datagrampacket.getData(), datagrampacket.getLength());
            } while(true);
        }
        catch(InterruptedIOException _ex) { }
        catch(Exception exception)
        {
            System.out.println("We're done! " + exception);
        }
    }

    public void setLoopback(boolean flag)
    {
        loopback = flag;
    }

    public void transmit(byte abyte0[], int i)
    {
        DatagramPacket datagrampacket = new DatagramPacket(abyte0, i, group, super.port);
        try
        {
            sock.send(datagrampacket);
        }
        catch(IOException ioexception)
        {
            System.out.println(ioexception);
            return;
        }
    }

    MulticastSocket sock;
    InetAddress group;
    Customer customer;
    Thread thread;
    boolean stopped;
    boolean loopback;
}
