/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ReaderTokenizer.java

package ncsa.util;

import java.io.PrintStream;
import java.io.Reader;

public class ReaderTokenizer
{

    public ReaderTokenizer(Reader reader1)
    {
        lineno = 1;
        chars = new int[65535];
        pushedBack = false;
        buf = new char[8192];
        reader = reader1;
        resetSyntax();
    }

    public int charType(int i)
    {
        return chars[i];
    }

    public void commentChar(int i)
    {
        chars[i] = 6;
    }

    public boolean eol()
    {
        return eol;
    }

    public void escapeChar(int i)
    {
        chars[i] = 8;
    }

    public int lineno()
    {
        return lineno;
    }

    public void newlineChar(int i)
    {
        chars[i] = 7;
    }

    public int nextToken()
    {
        eol = false;
        if(pushedBack)
        {
            ttype = pushed_ttype;
            sval = pushed_sval;
            nval = pushed_nval;
            pushedBack = false;
            eol = pushed_eol;
            return ttype;
        }
        k = 0;
        int i;
        while((i = read()) != '\uFFFF') 
            if(chars[i] != 1)
            {
                if(chars[i] == 4)
                {
                    sval = new String(String.valueOf(i));
                    ttype = i;
                    return i;
                }
                if(chars[i] == 6)
                {
                    while((i = read()) != '\uFFFF') 
                        if(chars[i] == 7)
                            break;
                } else
                {
                    if(chars[i] == 5)
                    {
                        boolean flag = false;
                        while((i = read()) != '\uFFFF') 
                        {
                            if(chars[i] == 5 && !flag)
                            {
                                sval = new String(buf, 0, k);
                                ttype = quote;
                                return ttype;
                            }
                            if(chars[i] == 8)
                            {
                                flag = true;
                            } else
                            {
                                flag = false;
                                buf[k++] = (char)i; // Modified from the decompiled code by Sean Luke, George Mason University
                            }
                        }
                        if(i == 65535)
                        {
                            sval = new String(buf, 0, k);
                            ttype = quote;
                            return ttype;
                        }
                    }
                    if(chars[i] == 3)
                    {
                        boolean flag1 = false;
                        boolean flag2 = false;
                        boolean flag3 = false;
                        boolean flag4 = false;
                        boolean flag5 = true;
                        if(i == 46)
                        {
                            flag4 = true;
                            buf[k++] = '0';
                        }
                        buf[k++] = (char)i;   // Modified from the decompiled code by Sean Luke, George Mason University
                        flag5 = false;
                        i = read();
                        if(i == 65535 || chars[i] == 1)
                        {
                            if(k == 1 && buf[0] == '-')
                                nval = (new Double(0.0D)).doubleValue();
                            else
                                nval = (new Double(buf[0] - 48)).doubleValue();
                            ttype = -102;
                            return -102;
                        }
                        if(chars[i] == 3 && (i != 45 || flag5))
                        {
                            buf[k++] = (char)i;   // Modified from the decompiled code by Sean Luke, George Mason University
                            if(i == 46)
                                flag4 = true;
                        } else
                        if(buf[0] == '0' && (i == 120 || i == 88))
                        {
                            buf[k++] = 'x';
                            flag2 = true;
                        } else
                        if(i == 101)
                        {
                            buf[k++] = 'e';
                            flag3 = true;
                            flag5 = true;
                        } else
                        {
                            flag1 = true;
                        }
                        if(!flag1)
                            while((i = read()) != '\uFFFF') 
                            {
                                if(i == 46)
                                {
                                    if(!flag2 && !flag4 && !flag3)
                                    {
                                        buf[k++] = '.';
                                        flag4 = true;
                                    }
                                    continue;
                                }
                                if(i == 101 || i == 69)
                                {
                                    flag5 = true;
                                    boolean _tmp = flag2 || flag3;
                                    buf[k++] = 'e';
                                    flag3 = true;
                                    i = read();
                                    if(i == 43 || i == 45)
                                        buf[k++] = (char)i;   // Modified from the decompiled code by Sean Luke, George Mason University
                                    continue;
                                }
                                if(chars[i] != 3 || i == 45 && !flag5)
                                    break;
                                buf[k++] = (char)i;   // Modified from the decompiled code by Sean Luke, George Mason University
                            }
                        if(i != 65535)
                            putback((char)i);   // Modified from the decompiled code by Sean Luke, George Mason University
                        String s = new String(buf, 0, k);
                        if(s.equals("-"))
                            s = new String("0");
                        if(flag4 || flag3)
                        {
                            Double double1 = new Double(s);
                            nval = double1.doubleValue();
                            ttype = -102;
                            return -102;
                        } else
                        {
                            Integer integer = Integer.decode(s);
                            nval = integer.doubleValue();
                            ttype = -102;
                            return -102;
                        }
                    }
                    if(chars[i] == 2)
                    {
                        for(buf[k++] = (char)i; (i = read()) != '\uFFFF'; buf[k++] = (char)i)
                            if(chars[i] != 2 && chars[i] != 3)
                                break;

                        if(i != 65535)
                            putback((char)i);
                        sval = new String(buf, 0, k);
                        ttype = -101;
                        return -101;
                    }
                }
            }
        ttype = -103;
        return -103;
    }

    public void ordinaryChar(int i)
    {
        chars[i] = 4;
    }

    public void parseNumbers()
    {
        for(int i = 48; i <= 57; i++)
            chars[i] = 3;

        chars[46] = 3;
        chars[45] = 3;
    }

    public void parseNumbersAsWords()
    {
        for(int i = 48; i <= 57; i++)
            chars[i] = 2;

        chars[46] = 2;
        chars[45] = 2;
    }

    public void pushBack()
    {
        pushed_ttype = ttype;
        pushed_sval = sval;
        pushed_nval = nval;
        pushedBack = true;
        pushed_eol = eol;
        eol = false;
    }

    public void putback(char c)
    {
        putbackChar = c;
    }

    public void quoteChar(int i)
    {
        if(quote != 0)
            chars[quote] = 0;
        chars[i] = 5;
        quote = i;
    }

    public char read()
    {
        eol = false;
        if(k + 5 > buf.length)
        {
            char ac[] = new char[buf.length + 1024];
            System.arraycopy(buf, 0, ac, 0, buf.length);
            buf = ac;
        }
        if(putbackChar != 0)
        {
            char c = putbackChar;
            putbackChar = '\0';
            return c;
        }
        char c1 = '\0';
        try
        {
            c1 = (char)reader.read();
        }
        catch(Exception exception)
        {
            System.out.println(exception);
        }
        if(c1 == '\uFFFF')
            return c1;
        if(chars[c1] == 7)
        {
            lineno++;
            eol = true;
        }
        return c1;
    }

    public void resetSyntax()
    {
        wordChars(0, 255);
        whitespaceChars(0, 32);
        whitespaceChar(44);
        quoteChar(34);
        ordinaryChar(123);
        ordinaryChar(125);
        ordinaryChar(91);
        ordinaryChar(93);
        ordinaryChar(47);
        escapeChar(92);
        newlineChar(10);
        commentChar(35);
        parseNumbers();
    }

    public void setType(int i, int j)
    {
        chars[i] = j;
    }

    public void whitespaceChar(int i)
    {
        chars[i] = 1;
    }

    public void whitespaceChars(int i, int j)
    {
        for(int l = i; l <= j; l++)
            chars[l] = 1;

    }

    public void wordChars(int i, int j)
    {
        for(int l = i; l <= j; l++)
            chars[l] = 2;

    }

    public static final int TT_WORD = -101;
    public static final int TT_NUMBER = -102;
    public static final int TT_EOF = -103;
    public static final int WHITESPACE = 1;
    public static final int WORDCHAR = 2;
    public static final int NUMBER = 3;
    public static final int TOKEN = 4;
    public static final int QUOTE = 5;
    public static final int COMMENT = 6;
    public static final int NEWLINE = 7;
    public static final int ESCAPE = 8;
    public final int MAXSIZE = 8192;
    public int ttype;
    public String sval;
    public double nval;
    public boolean eol;
    protected Reader reader;
    public int lineno;
    int chars[];
    char putbackChar;
    int quote;
    boolean pushedBack;
    String pushed_sval;
    double pushed_nval;
    int pushed_ttype;
    boolean pushed_eol;
    int k;
    char buf[];
}
