/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   IndexedPolygon.java

package ncsa.vecmath;

import java.util.Vector;
import javax.media.j3d.*;
import javax.vecmath.*;

// Referenced classes of package ncsa.vecmath:
//            IndexedInfo, PolygonTools, Triangle

public class IndexedPolygon
{

    public IndexedPolygon(Point3d apoint3d[], int ai[][])
    {
        tri = null;
        points = null;
        pointIndices = null;
        colors = null;
        colorIndices = null;
        normals = null;
        normalIndices = null;
        vec = new Vector();
        smoothing = false;
        creaseAngle = 0.0F;
        points = apoint3d;
        pointIndices = ai;
    }

    public IndexedPolygon(Point3f apoint3f[], int ai[][])
    {
        tri = null;
        points = null;
        pointIndices = null;
        colors = null;
        colorIndices = null;
        normals = null;
        normalIndices = null;
        vec = new Vector();
        smoothing = false;
        creaseAngle = 0.0F;
        Point3d apoint3d[] = new Point3d[apoint3f.length];
        for(int i = 0; i < apoint3f.length; i++)
            apoint3d[i] = new Point3d(apoint3f[i]);

        points = apoint3d;
        pointIndices = ai;
    }

    private void add(Triangle atriangle[])
    {
        for(int i = 0; i < atriangle.length; i++)
            vec.addElement(atriangle[i]);

    }

    public void calculatePointNormals(boolean flag)
    {
        smoothing = flag;
    }

    public IndexedTriangleArray getIndexedTriangleArray()
    {
        boolean flag = false;
        for(int i = 0; i < pointIndices.length; i++)
        {
            IndexedInfo aindexedinfo[] = new IndexedInfo[pointIndices[i].length];
            int k = 0;
            for(int i1 = 0; i1 < pointIndices[i].length; i1++)
            {
                aindexedinfo[k] = new IndexedInfo(pointIndices[i][i1]);
                if(colors != null)
                    aindexedinfo[k].setColorIndex(colorIndices[i][i1]);
                if(normals != null)
                    aindexedinfo[k].setNormalIndex(normalIndices[i][i1]);
                k++;
            }

            Triangle atriangle[] = tesselate(aindexedinfo);
            add(atriangle);
        }

        int j = vec.size() * 3;
        int l = 3;
        if(colors != null)
            l |= 4;
        tri = new IndexedTriangleArray(points.length, l, j);
        tri.setCapability(17);
        tri.setCapability(8);
        tri.setCapability(2);
        tri.setCapability(11);
        tri.setCapability(4);
        tri.setCapability(13);
        tri.setCapability(0);
        tri.setCapability(9);
        int j1 = 0;
        int ai[] = new int[j];
        for(int i2 = 0; i2 < vec.size(); i2++)
        {
            Triangle triangle = (Triangle)vec.elementAt(i2);
            ai[j1++] = triangle.first.getPoint3dIndex();
            ai[j1++] = triangle.second.getPoint3dIndex();
            ai[j1++] = triangle.third.getPoint3dIndex();
        }

        tri.setCoordinates(0, points);
        tri.setCoordinateIndices(0, ai);
        if(colors != null)
        {
            int k1 = 0;
            int ai1[] = new int[j];
            for(int j2 = 0; j2 < vec.size(); j2++)
            {
                Triangle triangle1 = (Triangle)vec.elementAt(j2);
                ai1[k1++] = triangle1.first.getColorIndex();
                ai1[k1++] = triangle1.second.getColorIndex();
                ai1[k1++] = triangle1.third.getColorIndex();
            }

            tri.setColors(0, colors);
            tri.setColorIndices(0, ai1);
        }
        if(normals != null)
        {
            int l1 = 0;
            int ai2[] = new int[j];
            for(int k2 = 0; k2 < vec.size(); k2++)
            {
                Triangle triangle2 = (Triangle)vec.elementAt(k2);
                ai2[l1++] = triangle2.first.getNormalIndex();
                ai2[l1++] = triangle2.second.getNormalIndex();
                ai2[l1++] = triangle2.third.getNormalIndex();
            }

            tri.setNormals(0, normals);
            tri.setNormalIndices(0, ai2);
        } else
        {
            Vector3f avector3f[] = PolygonTools.calculateIndexedNormals(points, ai, creaseAngle, 3);
            for(int l2 = 0; l2 < avector3f.length; l2++)
            {
                tri.setNormal(l2, avector3f[l2]);
                tri.setNormalIndices(0, ai);
            }

        }
        return tri;
    }

    public void setColors(Color3f acolor3f[], int ai[][])
    {
        colors = acolor3f;
        colorIndices = ai;
    }

    public void setCreaseAngle(float f)
    {
        creaseAngle = f;
    }

    public void setNormals(Vector3f avector3f[], int ai[][])
    {
        normals = avector3f;
        normalIndices = ai;
    }

    private Triangle[] tesselate(IndexedInfo aindexedinfo[])
    {
        int i = aindexedinfo.length - 2;
        Triangle atriangle[] = new Triangle[i];
        for(int j = 0; j < i; j++)
            atriangle[j] = new Triangle(aindexedinfo[0], aindexedinfo[j + 1], aindexedinfo[j + 2]);

        return atriangle;
    }

    IndexedTriangleArray tri;
    Point3d points[];
    int pointIndices[][];
    Color3f colors[];
    int colorIndices[][];
    Vector3f normals[];
    int normalIndices[][];
    private Vector vec;
    boolean smoothing;
    float creaseAngle;
}
